<?php

defined('SYSPATH') or die('No direct script access.');

class Model_Site_Media_Image extends Model_Content {

    protected $_table_name = 'content_sites_media';
    protected $_extends = array(
        'content' => array('table_name' => 'content', 'foreign_key' => 'id')
    );
    protected $_sorting = array('content.sort' => 'asc');
    protected $kind = 'Site_Media';
    protected $kind_id = 3;

    public function save() {
        if (is_array($this->image)) {
            if ($this->image['error'] == UPLOAD_ERR_OK) {
                $uploaded = Upload::save($this->image, $this->image['name'], 'media/upload/media/');
                Image::factory($uploaded)->resize(200, 100)->save();
                $uploaded_expl = explode(DIRECTORY_SEPARATOR, $uploaded);
                $this->delete_old_image();
                $this->image = end($uploaded_expl);
            } else {
                $this->image = ORM::factory('Site_Media_Image')->where('content_sites_media.id', '=', $this->id)->find()->image;
            }
        }
        if (is_array($this->anchor)) {
            if ($this->anchor['error'] == UPLOAD_ERR_OK) {
                $uploaded = Upload::save($this->anchor, $this->anchor['name'], 'media/upload/media/');
                $uploaded_expl = explode(DIRECTORY_SEPARATOR, $uploaded);
                $this->delete_old_anchor();
                $this->anchor = end($uploaded_expl);
            } else {
                $this->anchor = ORM::factory('Site_Media_Image')->where('content_sites_media.id', '=', $this->id)->find()->anchor;
            }
        } elseif (is_string($this->anchor)) {
            if ($this->anchor !== '') {
                if (!preg_match('/^http:\/\/.*/', $this->anchor)) {
                    $this->anchor = 'http://' . $this->anchor;
                }
            }
        }
        return parent::save();
    }

    public function delete($id = NULL) {
        $this->delete_old_image();
        $this->delete_old_anchor();
        parent::delete($id);
    }

    private function delete_old_image() {
        $media = ORM::factory('Site_Media_Image')->where('content_sites_media.id', '=', $this->id)->find();
        if ($media->image != '') {
            @unlink('media/upload/media/'.$media->image);
        }
    }
    private function delete_old_anchor() {
        $media = ORM::factory('Site_Media_Image')->where('content_sites_media.id', '=', $this->id)->find();
        if ($media->anchor_type==2 and $media->anchor != '') {
            @unlink('media/upload/media/'.$media->anchor);
        }
    }

    public function get_content_kind_id() {
        return $this->kind_id;
    }

}

?>
