<?php

defined('SYSPATH') or die('No direct script access.');

class Model_Site extends Model_Content_Translated {

    protected $_table_name = 'content_sites';
    protected $_extends = array(
        'content' => array('table_name' => 'content', 'foreign_key' => 'content_id')
    );
    protected $_sorting = array('content.sort' => 'asc');
    protected $kind = 'Site';
    protected $kind_id = 1;

    protected $translated = array('name', 'meta_title', 'meta_description', 'meta_keywords', 'body');

    protected function create_gallery() {
        $repo = ORM::factory('Gallery');
        $repo->gallery_kind = ORM::factory('Gallery_Kind')->where('name', '=', $this->kind)->find();
        $repo->element_id = $this->content_id;
        $repo->save();
    }

    protected function delete_gallery() {
        $this->gallery->delete();
    }

     protected function create_repository() {
        $repo_kind = (isset($this->repo_kind) ? $this->repo_kind : $this->kind);
        $repo = ORM::factory('Repository');
        $repo->repository_kind = ORM::factory('Repository_Kind')->where('name', '=', $repo_kind)->find();
        $repo->element_id = $this->content_id;
        $repo->save();
    }

    protected function delete_repository() {
        $this->repository->delete();
    }
    
}

?>
