<?php

defined('SYSPATH') or die('No direct script access.');

class Model_Partner extends Model_Content_Translated {

    protected $_table_name = 'content_partner';
    protected $_extends = array(
        'content' => array('table_name' => 'content', 'foreign_key' => 'content_id')
    );
    protected $_sorting = array('name' => 'asc');
    protected $kind = 'Partner';
    protected $kind_id = 2;

    protected $translated = array('name', 'www', 'image');

    public function save() {
        if ($this->www !== '') {
            if (!preg_match('/^http:\/\/.*/', $this->www)) {
                $this->www = 'http://' . $this->www;
            }
        }
        if (is_array($this->image)) {
            if ($this->image['error'] == UPLOAD_ERR_OK) {
                $uploaded = Upload::save($this->image, $this->image['name'], 'media/upload/partner/');
                Image::factory($uploaded)->resize(200, 100)->save();
                $uploaded_expl = explode(DIRECTORY_SEPARATOR, $uploaded);
                $this->delete_old_image();
                $this->image = end($uploaded_expl);
            } else {
                $this->image = ORM::factory('Partner')->where('content_partner.id', '=', $this->id)->find()->image;
            }
        }
        return parent::save();
    }

    public function delete($id = NULL) {
        $this->delete_all_images();
        return parent::delete($id);
    }

    private function delete_old_image() {
        $partner = ORM::factory('Partner')->where('content_partner.id', '=', $this->id)->find();
        if ($partner->image != '') {
            $check_image_used = ORM::factory('Partner')
                    ->where('content_partner.content_id', '=', $partner->content_id)
                    ->where('content_partner.language_id', '!=', $partner->language_id)
                    ->where('content_partner.image', '=', $partner->image)
                    ->find();
            if ($check_image_used->id == NULL or isset($_POST['all_lang'])) {
                @unlink('media/upload/partner/'.$partner->image);
            }
            if (isset($_POST['all_lang'])) {
                $this->delete_all_images();
            }
        }
    }

    private function delete_all_images() {
        $partner = ORM::factory('Partner')->where('content_partner.id', '=', $this->id)->find();
        $partners = ORM::factory('Partner')->where('content_partner.content_id', '=', $partner->content_id)->find_all();
        $images = array();
        foreach ($partners as $partner) {
            $images[$partner->image] = $partner->image;
        }
        foreach ($images as $image) {
            @unlink('media/upload/partner/' . $image);
        }
    }

}

?>
