<?php

defined('SYSPATH') or die('No direct script access.');

/**
 * Description of file
 *
 * @author User
 */
class Model_Image extends ORM {

    protected $_table_names_plural = FALSE;
    protected $_has_many = array('gallery' => array('through' => 'gallery_image'));
    protected $_db_reset = FALSE;
    protected $_sorting = array('sort' => 'asc');

    public function __set($name, $value) {
        if ($name == 'gallery') {
            //if the file is new add a dummy file as the id is needed
            //for the many to many relation ship (_has_many_thorugh)
            if ($this->is_new()) {
                $this->save_dummy();
            }
            $repo_file = ORM::factory('gallery_image')->
                            where($this->_table_name . '_id', '=', $this->pk())->
                            where($name . '_id', '=', $value->pk())->
                            find();
            $repo_file->gallery = $value;
            $repo_file->image = $this;
            $repo_file->save();
            return;
        }
        parent::__set($name, $value);
    }

    /**
     * this will remove the file from repository; not the file it self
     * unless $delete_orphan is true and file will not belong to any repository
     * @param <type> $gallery
     */
    public function remove_from_gallery($gallery, $delete_orphan = FALSE) {
        if (!is_int($gallery)) {
            $gallery = $gallery->pk();
        }
        DB::delete('gallery_image')->
                where($this->_table_name . '_id', '=', $this->pk())->
                where('gallery_id', '=', $gallery)->
                execute($this->_db);
        if ($this->is_orphan()) {
            $this->delete();
        }
    }

    public function is_orphan() {
        return $this->gallery->count_all() == 0;
    }

    protected function save_dummy() {
        if (!isset($this->name)) {
            $this->name = '';
        }
        if (!isset($this->path)) {
            $this->path = '';
        }
        $this->save();
    }

    public function delete($id = NULL, $config_array = array()) {
        if ($id === NULL) {
            $id = $this->pk();
        }
        $object = $this->where($this->_table_name.'.'.  $this->_primary_key, '=', $id)->find();
        if ($object->empty_pk()) {
            //if not found skip rest of the process
            return $this;
        }
        $object->before_delete($config_array);
        $object->delete_self($object->pk());
        return $this;
    }

    protected function before_delete($config_array = array()) {
        $this->delete_relations($this->pk());
        $this->delete_file($config_array);
    }

    protected function delete_file($config_array = array()) {
        $filepath = $this->path . '/' . $this->name;
        if (file_exists($filepath) && is_file($filepath)) {
            unlink($filepath);
        }
        if(isset($config_array['copies'])) {
            $filepath_expl = explode('/', $filepath);
            $filepath_fname = end($filepath_expl);
            foreach($config_array['copies'] as $copy) {
                if(isset($copy['prefix']) and UTF8::trim($copy['prefix']) != '') {
                    $filepath_copy = str_replace($filepath_fname, $copy['prefix'] . $filepath_fname, $filepath);
                    if (file_exists($filepath_copy) && is_file($filepath_copy)) {
                        unlink($filepath_copy);
                    }
                }
            }
        }
    }

    protected function delete_relations($id) {
        DB::delete('gallery_image')->where($this->_table_name . '_id', '=', $id)->execute();
    }

    public function find_files($number_of_files) {
        return $this->limit($number_of_files)->find_all();
    }

    /*public function save() {
        $sort = $this->sort;
        $new = $this->is_new();
	if (!$new && isset($this->_changed['sort'])) {
            if ($this->sort < $this->_original['sort']) {
		$this->change_sort_in_range($this->sort, $this->_original['sort'], 1);
	    } else {
		$this->change_sort_in_range($this->_original['sort'], $this->sort, -1);
	    }
        }
        if ($new) {
	    if (!isset($this->sort)) {
		$this->sort = ($this->get_max_sort() + 1);
                //var_dump($this->last_query(), $this); die;
	    }
	}
        parent::save();
        return $this;
    }

    public function get_max_sort() {
	return $this->count_all();
    } */

}

?>
