<?php

defined('SYSPATH') or die('No direct script access.');

class Model_Gallery extends ORM {
    const BASE_FILE_DIR='media/upload/gallery/';
    const MODE = 0777;

    protected $_has_many = array('images' => array('through' => 'gallery_image'));
    protected $_belongs_to = array('gallery_kind' => array());

    public static function get_repo_id_from_kind_and_element($kind_id, $element_id) {
	$repo = ORM::factory('Gallery')->where('gallery_kind_id', '=', $kind_id)
			->where('element_id', '=', $element_id)
			->find();
	return $repo->id;
    }

    /**
     * Constructor
     * @param array $id array of group_kind_id and element_id to guess the apropriate repository e.g. array( 'kind_id' => $kind_id, 'element_id' => $site_id )
     * @param int $id id of the repository
     */
    public function __construct($id = NULL) {
	if (is_array($id)) {
	    $id = Model_Gallery::get_repo_id_from_kind_and_element($id['kind_id'], $id['element_id']);
	}
	parent::__construct($id);
    }

    public function save() {
	$new = $this->is_new();
	parent::save();
	if ($new) {
	    mkdir($this->get_path(), self::MODE, TRUE);
	}
	return $this;
    }

    /**
     * @return string get path to directory of this repository
     */
    public function get_path() {
	return Model_Gallery::BASE_FILE_DIR . $this->gallery_kind_id . '/' . $this->element_id . '/';
    }

    public function get_owner_model() {
	$modelname = $this->gallery_kind->name;
	$model = ORM::factory($modelname, $this->element_id);
	return $model;
    }

    /**
     * save given file in the repository
     * @param array $file file being added, should be compatible with $_FILE['']
     * @param array $fields optional array of other fields(colums) to set; interpreted as array( [ $coulumn => $value, ... ] )
     */
    public function save_file($file, array $fields = array(), $config_array = array()) {
	$fname = (isset($config_array['prefix']) ? $config_array['prefix'] : '') . $this->prepare_file_name($file['name']);
	$fpath = $this->get_path();
	$file_orm = ORM::factory('Image');
	$fname = $this->prepare_name($fname);
	$file_orm->name = $fname;
	$file_orm->path = $fpath;
	/* @var $images Model_Image */
	$images = $this->images;
	$file_orm->sort = $images->count_all() + 1;
	$file_orm->gallery = $this;


	foreach ($fields as $field => $value) {
	    $file_orm->$field = $value;
	}
	$uploaded = Upload::save($file, $fname, $fpath);
	if (isset($config_array['width']) or isset($config_array['height'])) {
	    $width = ((isset($config_array['width']) and is_numeric($config_array['width'])) ? $config_array['width'] : NULL);
	    $height = ((isset($config_array['height']) and is_numeric($config_array['height'])) ? $config_array['height'] : NULL);
            $info = @getimagesize($uploaded);
            $original_width = $info[0];
            $original_height = $info[1];
	    $this->resize_saved_file($uploaded, $width, $height, $original_width, $original_height);
	}
	if (isset($config_array['copies'])) {
	    $uploaded_expl = explode(DIRECTORY_SEPARATOR, $uploaded);
	    $uploaded_fname = end($uploaded_expl);
	    foreach ($config_array['copies'] as $copy) {
		if (isset($copy['prefix']) and UTF8::trim($copy['prefix']) != '') {
		    $uploaded_copy = str_replace($uploaded_fname, $copy['prefix'] . $uploaded_fname, $uploaded);
		    $width = ((isset($copy['width']) and is_numeric($copy['width'])) ? $copy['width'] : NULL);
		    $height = ((isset($copy['height']) and is_numeric($copy['height'])) ? $copy['height'] : NULL);
		    copy($uploaded, $uploaded_copy);
		    $this->resize_saved_file($uploaded_copy, $width, $height, $original_width, $original_height);
		}
	    }
	}
	return $file_orm->save();
    }

    private function resize_saved_file($file_path, $width=NULL, $height=NULL, $original_width=NULL, $original_height=NULL) {
        if (($width < $original_width or $height < $original_height)) {
            Image::factory($file_path)->resize($width, $height)->save();
        }
    }

    private function prepare_file_name($original_name) {
        $original_name = UTF8::strtolower(preg_replace('/\s+/', '-', UTF8::transliterate_to_ascii($original_name)));
        $original_name = str_replace(array(',','"','\''),'',$original_name);
	return $original_name;
    }

    public function delete($id = NULL) {

	/* a preliminary get for path must be performed
	 * cause the data to determine the repository
	 * path might be deleted before retrieving */	
        $path = $this->get_path();

	if ($id === NULL) {
	    $id = $this->pk();
	}
	if ($this->delete_self($id) == 0) {
	    return $this;
	}
	if ($this->is_new()) {
	    throw new Exception('Trying to delete a not yet created repository.');
	}
	$this->delete_relations($id);
	self::rrmdir($path);
	return $this;
    }
    /**
     * returns element associated with the repository
     * @return Model elemenet associated with the repository
     */
    public function get_element() {
	$model_name = $this->gallery_kind->name;
	$model = ORM::factory($model_name, $this->element_id);
	return $model;
    }

    /**
     * removes appropirate relations of the repository being deleted
     * $param mixed $id id of the repository being destroyed
     * @var Model_File $file file being removed from repository
     */
    protected function delete_relations($id) {
	$images_in_gallery = $this->images->find_all();
	foreach ($images_in_gallery as $image) {
	    $image->remove_from_gallery($this, TRUE);
	}
    }

    protected function prepare_name($fname) {
	if ($this->file_exists($fname)) {
	    $dot_pos = strrpos($fname, '.');
	    if ($dot_pos)
		$name = str_split($fname, $dot_pos);
	    else {
		$name[0] = $fname;
		$name[1] = '';
	    }
	    $iter = 1;
	    do {
		$iter++;
		$fname = $name[0] . '(' . $iter . ')' . $name[1];
	    } while ($this->file_exists($fname));
	}
	return $fname;
    }

    /**
     * checks if the file with given name already exists within the repository
     * @param string $fname filename to check
     * @return number of files in the repository with given name should be 0 or 1
     */
    protected function file_exists($fname) {
	return $this->images->where('name', '=', $fname)->count_all();
    }

    /**
     * Helper function for recursive deletion of a directory
     * @param <type> $dir directory
     */
    protected static function rrmdir($dir) {
	if (is_dir($dir)) {
	    $objects = scandir($dir);
	    foreach ($objects as $object) {
		if ($object != "." && $object != "..") {
		    if (filetype($dir . "/" . $object) == "dir") {
			self::rrmdir($dir . "/" . $object);
		    } else {
			unlink($dir . "/" . $object);
		    }
		}
	    }
	    reset($objects);
	    rmdir($dir);
	}
    }
    public function change_sort_ondelete($id) {
        $image = $this->images->where('image.id', '=', $id)->find();
        $sort = $image->sort;
        $all = $this->images->where('image.sort','>',$sort)->find_all();

        $ids = array();
        foreach($all as $img) {
            $ids[] = $img->id;
        }

        if(count($ids)) {
            $query = " UPDATE ".$this->_db->table_prefix()."image SET sort=sort - 1 WHERE id IN (".implode(',',$ids).")";
            $this->_db->query(Database::UPDATE, $query, FALSE);
            $image->save();
        }
    }
    public function change_sort($id,$new_sort) {
        $image = $this->images->where('image.id', '=', $id)->find();
        $old_sort = $image->sort;
        if($old_sort > $new_sort) {
            $all = $this->images->where('image.id', '!=', $id)->where('image.sort','<',$old_sort)->where('image.sort','>=',$new_sort)->find_all();
        }
        else  {
            $all = $this->images->where('image.id', '!=', $id)->where('image.sort','>',$old_sort)->where('image.sort','<=',$new_sort)->find_all();
        }
        $ids = array();
        foreach($all as $img) {
            $ids[] = $img->id;
        }
        if(count($ids)) {
            $query = " UPDATE ".$this->_db->table_prefix()."image SET sort=sort".($new_sort>$old_sort ? '-' : '+')."1 WHERE id IN (".implode(',',$ids).")";
            $this->_db->query(Database::UPDATE, $query, FALSE);
            $image->sort = $new_sort;
            $image->save();
        }
    }

}

?>
