<?php

defined('SYSPATH') or die('No direct script access.');

/**
 * Description of file
 *
 * @author User
 */
class Model_File extends ORM {

    protected $_table_names_plural = FALSE;
    protected $_has_many = array('repository' => array('through' => 'repository_file'));
    protected $_db_reset = FALSE;

    public function __set($name, $value) {
        if ($name == 'repository') {
            //if the file is new add a dummy file as the id is needed
            //for the many to many relation ship (_has_many_thorugh)
            if ($this->is_new()) {
                $this->save_dummy();
            }
            $repo_file = ORM::factory('repository_file')->
                            where($this->_table_name . '_id', '=', $this->pk())->
                            where($name . '_id', '=', $value->pk())->
                            find();
            $repo_file->repository = $value;
            $repo_file->file = $this;
            $repo_file->save();
            return;
        }
        parent::__set($name, $value);
    }

    /**
     * this will remove the file from repository; not the file it self
     * unless $delete_orphan is true and file will not belong to any repository
     * @param <type> $repository
     */
    public function remove_from_repository($repository, $delete_orphan = FALSE) {
        if (!is_int($repository)) {
            $repository = $repository->pk();
        }
        DB::delete('repository_file')->
                where($this->_table_name . '_id', '=', $this->pk())->
                where('repository_id', '=', $repository)->
                execute($this->_db);
        if ($this->is_orphan()) {
            $this->delete();
        }
    }

    public function is_orphan() {
        return $this->repository->count_all() == 0;
    }

    protected function save_dummy() {
        if (!isset($this->name)) {
            $this->name = '';
        }
        if (!isset($this->path)) {
            $this->path = '';
        }
        $this->save();
    }

    protected function before_delete() {
        $this->delete_relations($this->pk());
        $this->delete_file();
    }

    protected function delete_file() {
        $filepath = $this->path . '/' . $this->name;
        if (file_exists($filepath) && is_file($filepath)) {
            unlink($filepath);
        }
    }

    protected function delete_relations($id) {
        DB::delete('repository_file')->where($this->_table_name . '_id', '=', $id)->execute();
    }

}

?>
