<?php

defined('SYSPATH') or die('No direct script access.');

class Model_Content_Translated extends Model_Content {

    protected $ignored_translations = array();
    protected $translated = array();
    protected $_has_one = array(
        'repository' => array('foreign_key' => 'element_id', 'far_key' => 'content_id'),
        'gallery' => array('foreign_key' => 'element_id', 'far_key' => 'content_id')
    );
    protected $current_language = NULL;

    public function __construct($id = NULL) {
        parent::__construct($id);
        $this->current_language = Kohana_Session::instance()->get('application_language');
    }

    protected function text_filter() {
        return $this
                ->where('content.kind_id', '=', $this->kind_id)
                ->where($this->_table_name . '.language_id', '=', $this->current_language);
    }

    public function __get($path) {
        if (array_key_exists($path, $this->_has_one) or array_key_exists($path, $this->_has_many)) {
            $this->_primary_key = 'content_id';
            if (isset($this->_has_many[$path])) {
                $model = ORM::factory($this->_has_many[$path]['model']);
                if (array_key_exists('_table_name', get_object_vars($model))) {
                    if (isset($this->_has_many[$path]['through'])) {
                        $through = $this->_has_many[$path]['through'];
                        $join_col1 = $through . '.' . $this->_has_many[$path]['far_key'];
                        $join_col2 = $model->_table_name . '.content_id';
                        $model->join($through)->on($join_col1, '=', $join_col2);
                        $col = $through . '.' . $this->_has_many[$path]['foreign_key'];
                        $val = $this->pk();
                    } else {
                        $col = $model->_table_name . '.' . $this->_has_many[$path]['foreign_key'];
                        $val = $this->pk();
                    }
                    return $model->where($col, '=', $val);
                }
            }
            $item = parent::__get($path);
            $this->_primary_key = 'id';
            return $item;
        }
        return parent::__get($path);
    }

    public function find_all() {
        $this->text_filter();
        return parent::find_all();
    }

    public function save() {
        $parent = NULL;
        $is_new = $this->is_new();
        if ($this->content->id_parent == NULL) {
            $parent = (int) @$_GET['parent'];
        }
        $model = parent::save();

        if ($parent !== NULL) {
            ORM::factory('Content')->where('id', '=', $model->content_id)->find()->values(array('id_parent' => $parent))->save();
        }

        $table_prefix = Database::instance()->table_prefix();
        $translated_values = array();
        foreach ($this->translated as $field_name) {
            $translated_values[] = "'" . $model->$field_name . "'";
        }
        if ($is_new) {
            // dopisz wartości dla każdego języka
            foreach (ORM::factory('Language')->find_all() as $language) {
                if ($language->id !== $model->language_id) {
                    DB::query(
                            Database::INSERT,
                            "Insert Into " . $table_prefix . $this->_table_name . " (content_id, language_id, " . implode(',', $this->translated) . ") " .
                            "Values(" . $model->content_id . ", " . $language->id . ", " . implode(',', $translated_values) . ")"
                            )->execute();
                }
            }
        } else {
            if(isset($_POST['all_lang'])) {
                $query = "Update " . $table_prefix . $this->_table_name . " Set ";
                $translated_values = array();
                foreach ($this->translated as $field_name) {
                    $translated_values[] = " " . $field_name . " = '" . $model->$field_name . "' ";
                }
                $query .= implode(',', $translated_values);
                $query .= "Where content_id = " . $model->content_id;
                DB::query(
                        Database::UPDATE,
                        $query
                        )->execute();
            }
        }
        if (!empty($this->ignored_translations)) {
            $update_fields = array();
            foreach ($this->ignored_translations as $field_name) {
                $update_fields[] = " " .$field_name . "='" . $model->$field_name . "' ";
            }
            DB::query(
                    Database::UPDATE,
                    "Update " . $table_prefix . $this->_table_name . " Set " .
                    implode(',', $update_fields) . " " .
                    "Where content_id=" .$model->content_id
                    )->execute();
        }

        return $model;
    }

    public function delete($id = NULL) {
        $table_prefix = Database::instance()->table_prefix();
        DB::query(
                Database::DELETE,
                "Delete From " . $table_prefix . $this->_table_name .
                " Where content_id=" . $this->content_id . " And language_id<>".$this->current_language
                )->execute();
        return parent::delete($id);
    }

    public function translate_element_id_to_content_id($id) {
        return ORM::factory($this->kind)
                ->where($this->_table_name . '.id', '=', $id)
                ->find()->content_id;
    }

    public function get_tree($parent = 0) {
        $content_db = $this->find_all()->as_array();
        $list = array();
        $tree = array();
        foreach ($content_db as $content) {
            $content['id'] = $content['content_id'];
            $list[$content->content_id] = $content->as_array();
        }
        $tree = $this->get_kids($list, $parent, 0, TRUE);
        return $tree;
    }

    private function get_kids($array, $parent, $main_parent = NULL, $full = FALSE) {
        $tree = array();
        foreach ($array as $key => $item) {
            if ($item['id_parent'] == $parent) {
                $tree[$item['id']] = $item;
                unset($array[$key]);
                if (is_null($main_parent) or $item['id'] == $main_parent or $full) {
                    $sub = $this->get_kids($array, $item['id']);
                    if (count($sub) > 0) {
                        $tree[$item['id']]['sub'] = $sub;
                    }
                }
            }
        }
        return $tree;
    }

    public function get_as_selectbox_options($empty = FALSE) {
        $content = array();
        if ($empty) {
            $content[0] = '-- wybierz --';
        }
        $content_db = $this->get_tree();
        $list = $this->tree_to_list($content_db, 0, '', TRUE, TRUE);
        foreach ($list as $value) {
            $content[$value['id']] = $value['name'];
        }
        return $content;
    }

}

?>
