<?php

defined('SYSPATH') or die('No direct script access.');

class Model_Content extends Model_Text {

    protected $_belongs_to = array(
        'content_kind' => array('foreign_key' => 'kind_id')
    );

    public function __get($path) {
        if ($path === 'content_kind') {
            return ORM::factory('Content_Kind')->where('id', '=', $this->kind_id)->find();
        } else {
            return parent::__get($path);
        }
    }

    public function get_tree() {
        $content_db = $this->find_all()->as_array();
        $list = array();
        $tree = array();
        foreach ($content_db as $content) {
            $list[$content->id] = $content->as_array();
        }
        $tree = $this->get_kids($list, 0, 0, TRUE);
        return $tree;
    }

    private function get_kids($array, $parent, $main_parent = NULL, $full = FALSE) {
        $tree = array();
        foreach ($array as $key => $item) {
            if ($item['id_parent'] == $parent) {
                $tree[$item['id']] = $item;
                unset($array[$key]);
                if (is_null($main_parent) or $item['id'] == $main_parent or $full) {
                    $sub = $this->get_kids($array, $item['id']);
                    if (count($sub) > 0) {
                        $tree[$item['id']]['sub'] = $sub;
                    }
                }
            }
        }
        return $tree;
    }

    function tree_to_list($tree, $level=0, $begin_string='', $last_element = true, $block=false) {
        if (empty($tree))
            return array();
        else {
            $list = array();
            $length = count($tree);
            if ($last_element == true) {
                if ($level != 0) {
                    $begin_string.= '&nbsp;';
                }
            } else {
                $begin_string.= '│';
            }
            $iter = 0;
            foreach ($tree as $i => $v) {
                $iter++;
                if ($iter == $length) {
                    $symbol = '└';
                    $last_element = true;
                } else {
                    $symbol = '├';
                    $last_element = false;
                }
                $symbol .= isset($tree[$i]['sub']) ? '┬' : '─';
                $list[] = array(
                    'name' => $begin_string . $symbol . $tree[$i]['name'],
                    'id' => $tree[$i]['id']
                );
                if (!empty($tree[$i]['sub']) && $block) {
                    end($list);
                    $list[key($list)]['block'] = true;
                    $list = array_merge($list, $this->tree_to_list($tree[$i]['sub'], $level + 1, $begin_string, $last_element, $block));
                }
            }
            return $list;
        }
    }

    public function get_as_selectbox_options() {
        $content = array(0 => '-- wybierz --');
        $content_db = $this->get_tree();
        $list = $this->tree_to_list($content_db, 0, '', TRUE, TRUE);
        foreach ($list as $value) {
            $content[$value['id']] = $value['name'];
        }
        return $content;
    }

}

?>
