<?php

defined('SYSPATH') or die('No direct script access.');

/**
 * Cechy ogólne dla menu
 *
 * @author Andrzej Skupień
 * @version 1.0
 */
class Menu {

    /**
     *
     * @var View widok menu
     */
    protected $template;
    protected $links;
/**
 *
 * @param string $template nazwa widoku
 */
    public function __construct($template) {
	$this->template = Kohana_View::factory($template);
    }

    public function __toString() {
	try {
	    return $this->render();
	} catch (Exception $e) {
	    // Display the exception message
	    Kohana::exception_handler($e);
	    return '';
	}
    }

    /**
     *
     * @param Link $link pozycja menu
     */
    public function add_link(Link $link) {
	$this->links[] = $link;
    }

    /**
     * Masowe dodawanie linków do menu. Linki powiny być typu Link
     * inaczej zoastanie wyrzuciny wyjątek o niezgodności typów
     * @param array $links tablica z linkami typu Link
     */
    public function add_links(array $links) {
	foreach ($links as $link) {
	    $this->add_link($link);
	}
    }

    public function render() {
	$this->template->links = $this->links;
	return $this->template->render();
    }

}

?>
