<?php defined('SYSPATH') or die('No direct script access.');

class Helper_Mailer {

    public static function send_mail(
            $message_config_name,
            $content,
            $from_email,
            $from_name = '',
            $to_email,
            $to_name = '',
            $notify = TRUE,
            $add_title = '') {
        $option_message = Option::factory($message_config_name);
        $recipients = array();
        $mailing_config = Kohana::config('mailing');
        $message_body = $mailing_config['styles'] . $mailing_config['head'];
        $message_body .=
                        $option_message->head .
                        '<div style="margin: 15px 0px;">' .
                        $content .
                        '</div>' .
                        $option_message->foot;
        $message_body .= $mailing_config['foot'];
        
        $message = new Email_Message(
                        ($add_title != '' ? $add_title . ' - ' : '') . $option_message->title,
                        $message_body,
                        $from_email,
                        ($from_name != '' ? $from_name : $from_email),
                        $from_email
        );

        $mailer = new Email_Sender($message, array(
            $to_email => ($to_name != '' ? $to_name : $to_email)
        ));
        $result = $mailer->send();

        if ($notify) {
            $message = new Email_Message(
                            ($add_title != '' ? $add_title . ' - ' : '') . $option_message->title,
                            $message_body,
                            $to_email,
                            ($to_name != '' ? $to_name : $to_email),
                            $to_email
            );
            $mailer = new Email_Sender($message, array(
                $from_email => ($from_name != '' ? $from_name : $from_email)
            ));
            $mailer->send();
        }
        if (count($result) > 0) {
            return true;
        }
        return false;
    }

}

?>

