<?php

defined('SYSPATH') or die('No direct script access.');

abstract class Helper_Entity {

    public function __get($name) {
        $methodName = 'get_' . $name;
        if (method_exists($this, $methodName)) {
            return call_user_func(array($this, $methodName));
        }
        if (property_exists($this, $name)) {
            return $this->$name;
        }
        throw new Exception('Właściwość ' . $name . ' nie w istnieje klasie ' . get_class($this));
    }

    public function __set($name, $value) {
        $methodName = 'set_' . $name;
        if (method_exists($this, $methodName)) {
            return call_user_func(array($this, $methodName), $value);
        }
        if (property_exists($this, $name)) {
            $this->$name = $value;
            return;
        }
        throw new Exception('Właściwość ' . $name . ' nie w istnieje klasie ' . get_class($this));
    }

}

?>
