<?php

defined('SYSPATH') or die('No direct script access.');

class Form_User_Password extends Widget_Form {

    protected $exclude_fields = array('password2', 'old_password');
    //TODO: id_unit powtarzać się będzie praktycznie w każdym formularzu, naelży zrefaktoryzować
    private $id_edit = NULL;

    public function __construct($action = '', $values = array(), array $attributes = array(), $files = array()) {
	//TODO: ustawianie id_powtarzać siębędzie w każdym miejscu, trzba będzie zrefaktoryzować
	$this->id_edit = (isset($values['id']) ? $values['id'] : NULL);
	if (!isset($values['password2'])) {
	    //assumption that the password is not being changed but given from orm
	    unset($values['password']);
	}
	parent::__construct($action, $values, $attributes, $files);
    }

    protected function prepare_fields() {
	$this->fields['old_password'] = new Widget_Form_Field_Password('old_password', '', 'Aktualne hasło');
	$this->fields['password'] = new Widget_Form_Field_Password('password', '', 'Nowe hasło');
	$this->fields['password2'] = new Widget_Form_Field_Password('password2', '', 'Powtórz nowe hasło');
	$this->apply_properties();
    }

    protected function prepare_buttons() {
	$this->buttons[] = new Widget_Form_Field_Submit('change_pass', 'Zmień hasło', array('class' => 'button_white'));
    }

    protected function apply_properties() {
        $this->fields['old_password']->add_rules(array('not_empty'));
        $this->fields['password2']->add_rules(array('not_empty'));
        $this->fields['password2']->add_rules(array('not_empty'));
	//TODO:  Uprościć dodawanie filtra is unique
	$this->fields['password']->add_rules(array('not_matches' => array('old_password')));
	$this->fields['password2']->add_rules(array('matches' => array('password')));

        $this->fields['old_password']->add_callback(array('Form_User_Password', 'check_password'));
    }

    public static function check_password($validate, $field) {
        if(simpleauth::instance()->get_user()->password !== simpleauth::instance()->hash($_POST[$field])) {
            $validate->error($field, 'bad_pass');
        }
    }

}

?>
