<?php

defined('SYSPATH') or die('No direct script access.');

class Form_User extends Widget_Form {

    protected $new_user = FALSE;
    protected $exclude_fields = array('password2');
    //TODO: id_unit powtarzać się będzie praktycznie w każdym formularzu, naelży zrefaktoryzować
    private $id_edit = NULL;

    public function __construct($action = '', $values = array(), array $attributes = array(), $files = array()) {
	//TODO: ustawianie id_powtarzać siębędzie w każdym miejscu, trzba będzie zrefaktoryzować
	$this->id_edit = (isset($values['id']) ? $values['id'] : NULL);
	$this->new_user = $this->is_new_user_form($values);
	if (!isset($values['password2'])) {
	    //assumption that the password is not being changed but given from orm
	    unset($values['password']);
	}
	parent::__construct($action, $values, $attributes, $files);
    }

    protected function prepare_fields() {
	$this->fields['email'] = new Widget_Form_Field_Input('email', '', 'E-mail (login)');
	$this->fields['username'] = new Widget_Form_Field_Input('username', '', 'Pełna nazwa użytkownika');
	$this->fields['password'] = new Widget_Form_Field_Password('password', '', 'Hasło');
	$this->fields['password2'] = new Widget_Form_Field_Password('password2', '', 'Powtórz hasło');
	$this->apply_properties();
    }

    protected function prepare_buttons() {
	$this->buttons[] = new Widget_Form_Field_Submit('submit', 'Zapisz', array('class' => 'button_white'));
	if (!$this->new_user) {
	    $this->buttons[] = HTML::anchor('admin/user/back', 'Anuluj', array('class' => 'button_white'));
	}
    }

    protected function apply_properties() {
	if ($this->new_user) {
	    $this->fields['password']->add_rules(array('not_empty'));
	} else {
	    
	}
	//TODO:  Uprościć dodawanie filtra is unique
	$this->fields['email']->add_rules(array('not_empty', 'email', 'Widget_Form::is_field_unique' => array('email', 'Auth_Users', $this->id_edit)));
	$this->fields['username']->add_rules(array('not_empty', 'Widget_Form::is_field_unique' => array('username', 'Auth_Users', $this->id_edit)));
	$this->fields['password2']->add_rules(array('matches' => array('password')));
    }

    protected function is_new_user_form($values) {
	return empty($values) OR empty($values['id']);
    }

}

?>
