<?php

defined('SYSPATH') or die('No direct script access.');

class Form_Translation_Base extends Widget_Form {

    protected $new_item = FALSE;
    protected $id_edit = NULL;
    protected $values = NULL;

    public function __construct($action = '', $values = array(), array $attributes = array(), $files = array()) {
        $this->values = $values;
        $new_values = array();
        foreach ($values as $key => $value) {
            if (is_array($value)) {
                $new_values['value_'.$value['language_id']] = $value['value'];
            } else {
                $new_values[$key] = $value;
            }
        }
        $values = $new_values;
        $this->new_item = $this->is_new_file_form($values);
        parent::__construct($action, $values, $attributes, $files);
    }

    protected function prepare_fields() {
        $this->apply_properties();
    }

    protected function prepare_buttons() {
        $this->buttons[] = new Widget_Form_Field_Submit('save', 'Zapisz', array('class' => 'button_white'));
        $this->buttons[] = new Widget_Form_Field_Submit('back', 'Anuluj', array('class' => 'button_white'));
    }

    protected function apply_properties() {
    }

    protected function is_new_file_form($values) {
        return empty($values) OR empty($values['id']);
    }

}

?>
