<?php

defined('SYSPATH') or die('No direct script access.');

class Form_Site_Media_Image extends Widget_Form {

    protected $new_file = FALSE;

    public function __construct($action = '', $values = array(), array $attributes = array(), $files = array()) {
        $this->new_file = $this->is_new_file_form($values);
        parent::__construct($action, $values, $attributes, $files);
    }

    protected function prepare_fields() {
        $this->fields['image'] = new Widget_Form_Field_File('image', 'Logotyp', array('style' => 'width: 300px'));
        $this->fields['anchor_type'] = new Widget_Form_Field_Select('anchor_type', array(1=>'Zewnętrzny odnośnik', 2=>'Plik'), 'Typ artykułu');
        $this->fields['anchor_text'] = new Widget_Form_Field_Input('anchor_text', NULL, 'Odnośnik', array('style' => 'width: 300px'));
        $this->fields['anchor_file'] = new Widget_Form_Field_File('anchor_file', 'Plik', array('style' => 'width: 300px'));
        $this->apply_properties();
    }

    protected function prepare_buttons() {
        $this->buttons[] = new Widget_Form_Field_Submit('save', 'Zapisz', array('class' => 'button_white'));
        $this->buttons[] = new Widget_Form_Field_Submit('back', 'Anuluj', array('class' => 'button_white'));
    }

    protected function apply_properties() {
        if ($this->new_file) {
            $this->fields['image']->add_rules(array('Upload::not_empty', 'Upload::is_image'));
        }
    }

    protected function is_new_file_form($values) {
        return empty($values) OR empty($values['id']);
    }

}

?>
