<?php

defined('SYSPATH') or die('No direct script access.');

class Form_Site extends Widget_Form {

    protected $is_new = FALSE;

    public function __construct($action = '', $values = array(), array $attributes = array(), $files = array()) {
        $this->is_new = $this->is_new_form($values);
        parent::__construct($action, $values, $attributes, $files);
    }

    protected function prepare_fields() {
        $this->fields['name'] = new Widget_Form_Field_Input('name', '', 'Tytuł', array('style' => 'width: 300px', 'class' => 'first_input'));
        $this->fields['meta_title'] = new Widget_Form_Field_Input('meta_title', '', 'META title', array('style' => 'width: 300px'));
        $this->fields['meta_description'] = new Widget_Form_Field_Input('meta_description', '', 'META description', array('style' => 'width: 300px'));
        $this->fields['meta_keywords'] = new Widget_Form_Field_Input('meta_keywords', '', 'Słowa kluczowe', array('style' => 'width: 300px'));
        $this->fields['body'] = new Widget_Form_Field_Textarea('body', '', 'Treść', array('class' => 'tinymce', 'style' => 'width: 600px; height: 300px'));
        $this->apply_properties();
    }

    protected function prepare_buttons() {
        $this->buttons[] = new Widget_Form_Field_Submit('save', 'Zapisz', array('class' => 'button_white'));
        $this->buttons[] = HTML::anchor('admin/site/back' . ((int) @$_GET['parent'] > 0 ? '?parent=' . $_GET['parent'] : ''), 'Anuluj', array('class' => 'button_white'));
    }
    
    protected function apply_properties() {
        $this->fields['name']->add_filters(array('trim'));
        $this->fields['name']->add_rules(array('not_empty'));
    }

    protected function is_new_form($values) {
        return empty($values) OR empty($values['id']);
    }

}

?>
