<?php

defined('SYSPATH') or die('No direct script access.');

class Form_Partner extends Widget_Form {

    protected $is_new = FALSE;
    private $id_edit = NULL;
    protected $exclude_fields = array('all_lang');

    public function __construct($action = '', $values = array(), array $attributes = array(), $files = array()) {
        $this->is_new = $this->is_new_form($values);
        $this->id_edit = (isset($values['id']) ? $values['id'] : NULL);
        parent::__construct($action, $values, $attributes, $files);
    }

    protected function prepare_fields() {
        $this->fields['name'] = new Widget_Form_Field_Input('name', '', 'Nazwa', array('style' => 'width: 300px', 'class' => 'first_input'));
        $this->fields['www'] = new Widget_Form_Field_Input('www', '', 'Strona WWW', array('style' => 'width: 300px'));
        $this->fields['image'] = new Widget_Form_Field_File('image', 'Logotyp');
        if (!$this->is_new) {
            $this->fields['all_lang'] = new Widget_Form_Field_Checkbox('all_lang', NULL, 'Zapisz takie same wartości dla wszystkich wersji językowych');
        }
        $this->apply_properties();
    }

    protected function prepare_buttons() {
        $this->buttons[] = new Widget_Form_Field_Submit('save', 'Zapisz', array('class' => 'button_white'));
        $this->buttons[] = HTML::anchor('admin/partner/back', 'Anuluj', array('class' => 'button_white'));
    }

    protected function apply_properties() {
        $this->fields['name']->add_filters(array('trim'));
        $this->fields['name']->add_rules(array('not_empty', 'Widget_Form::is_field_unique' => array('name', 'Partner', $this->id_edit)));
        $this->fields['image']->add_rules(array('Upload::is_image' => array(TRUE)));
    }

    protected function is_new_form($values) {
        return empty($values) OR empty($values['id']);
    }

}

?>
