<?php

defined('SYSPATH') or die('No direct script access.');

class Form_Message extends Widget_Form {

    protected function prepare_buttons() {
        $this->buttons[] = new Widget_Form_Field_Submit('save', 'Zapisz', array('class' => 'button_white'));
        $this->buttons[] = HTML::anchor(URL::base() . 'admin/message', 'Anuluj', array('class' => 'button_white'));
    }

    protected function prepare_fields() {
        $this->fields['title'] = new Widget_Form_Field_Input('title', '', 'Tytuł', array('style' => 'width: 500px'));
        $this->fields['head'] = new Widget_Form_Field_Textarea('head', '', 'Nagłówek', array('class' => 'tinymce', 'style' => 'width: 600px; height: 300px'));
        $this->fields['foot'] = new Widget_Form_Field_Textarea('foot', '', 'Stopka', array('class' => 'tinymce', 'style' => 'width: 600px; height: 300px'));
        $this->apply_properties();
    }

    protected function apply_properties() {
        $this->fields['title']->add_filters(array('trim'));
        $this->fields['head']->add_filters(array('trim'));
        $this->fields['foot']->add_filters(array('trim'));
        $this->fields['title']->add_rules(array('not_empty'));
    }

}

?>
