<?php

defined('SYSPATH') or die('No direct script access.');

class Form_Language extends Widget_Form {

    protected $new_item = FALSE;
    private $id_edit = NULL;

    public function __construct($action = '', $values = array(), array $attributes = array(), $files = array()) {
        $this->new_item = $this->is_new_file_form($values);
        $this->id_edit = (isset($values['id']) ? $values['id'] : NULL);
        parent::__construct($action, $values, $attributes, $files);
    }

    protected function prepare_fields() {
        $this->fields['name'] = new Widget_Form_Field_Input('name', '', 'Nazwa języka', array('style' => 'width: 300px', 'class' => 'first_input'));
        $this->fields['short_name'] = new Widget_Form_Field_Input('short_name', '', 'Skrót', array('style' => 'width: 30px', 'maxlength'=>'3'));
        $this->fields['show'] = new Widget_Form_Field_Select('show', array(0=>'Nie', 1=>'Tak'), 'Widoczny');
        $this->apply_properties();
    }

    protected function prepare_buttons() {
        $this->buttons[] = new Widget_Form_Field_Submit('save', 'Zapisz', array('class' => 'button_white'));
        $this->buttons[] = new Widget_Form_Field_Submit('back', 'Anuluj', array('class' => 'button_white'));
    }

    protected function apply_properties() {
        $this->fields['name']->add_filters(array('trim'));
        $this->fields['short_name']->add_filters(array('trim'));
        $this->fields['name']->add_rules(array('not_empty', 'Widget_Form::is_field_unique' => array('name', 'Language', $this->id_edit)));
        $this->fields['short_name']->add_rules(array('not_empty', 'Widget_Form::is_field_unique' => array('short_name', 'Language', $this->id_edit)));
    }

    protected function is_new_file_form($values) {
        return empty($values) OR empty($values['id']);
    }

}

?>
