<?php

defined('SYSPATH') or die('No direct script access.');

class Form_Image_Project extends Widget_Form {

    protected $new_file = FALSE;

    public function __construct($action = '', $values = array(), array $attributes = array(), $files = array()) {
        $this->new_file = $this->is_new_file_form($values);
        parent::__construct($action, $values, $attributes, $files);
    }

    protected function prepare_fields() {
        $this->fields['label'] = new Widget_Form_Field_Input('label', '', 'Etykieta', array('style' => 'width: 300px', 'class' => 'first_input'));
        $this->fields['label_en'] = new Widget_Form_Field_Input('label_en', '', 'Etykieta (wersja angielska)', array('style' => 'width: 300px'));
        if ($this->new_file) {
            $this->fields['file'] = new Widget_Form_Field_File('file', 'Plik', array('style' => 'width: 300px'));
        }
        $this->fields['category_id'] = new Widget_Form_Field_Select('category_id', ORM::factory('Site_Middle')->get_as_selectbox_options(TRUE), 'Kategoria', NULL, array('class' => 'tree'));
        $this->apply_properties();
    }

    protected function prepare_buttons() {
        $this->buttons[] = new Widget_Form_Field_Submit('save', 'Zapisz', array('class' => 'button_white'));
        if (!$this->new_file) {
            $this->buttons[] = new Widget_Form_Field_Submit('back', 'Anuluj', array('class' => 'button_white'));
        }
    }

    protected function apply_properties() {
        $this->fields['label']->add_filters(array('trim'));
        $this->fields['label']->add_rules(array('not_empty'));
        if ($this->new_file) {
            $this->fields['file']->add_rules(array('Upload::not_empty', 'Upload::is_image'));
        }
    }

    protected function is_new_file_form($values) {
        return empty($values) OR empty($values['id']);
    }

}

?>
