<?php defined('SYSPATH') or die('No direct script access.');

class Form_Front_Contact extends Widget_Form {

    public function __construct($action = '', $values = array(), array $attributes = array(), $files = array()) {
	parent::__construct($action, $values, $attributes, $files);
        $this->translations = Kohana_Session::instance()->get('translate');
    }

    protected function prepare_buttons() {
        $this->buttons[] = new Widget_Form_Field_Submit('send', $this->translations->BUTTON_wyslij_wiadomosc, array('class' => 'button1'));
    }

    protected function prepare_fields() {
        $this->fields['name'] = new Widget_Form_Field_Input('name', '', $this->translations->LABEL_imie, array('class' => 'txt first_input', 'style' => 'width: 97%;'));
        $this->fields['email'] = new Widget_Form_Field_Input('email', '', $this->translations->LABEL_adres_email, array('class' => 'txt', 'style' => 'width: 97%;'));
        $this->fields['message'] = new Widget_Form_Field_Textarea('message', '', $this->translations->LABEL_tresc_wiadomosci, array('class' => 'txt', 'style' => 'width: 97%; height: 135px'));
        $this->apply_properties();
    }

    protected function apply_properties() {
        $this->fields['name']->add_filters(array('trim'));
        $this->fields['email']->add_filters(array('trim'));
        $this->fields['message']->add_filters(array('trim'));
        $this->fields['name']->add_rules(array('not_empty'));
        $this->fields['email']->add_rules(array('not_empty', 'email'));
        $this->fields['message']->add_rules(array('not_empty'));
    }

}

?>
