<?php

defined('SYSPATH') or die('No direct script access.');

class Form_File extends Widget_Form {

    protected $new_file = FALSE;

    public function __construct($action = '', $values = array(), array $attributes = array(), $files = array()) {
        $this->new_file = $this->is_new_file_form($values);
        parent::__construct($action, $values, $attributes, $files);
        if ($this->new_file) {
            $this->attributes['enctype'] = 'multipart/form-data';
        }
    }

    protected function prepare_fields() {
        $this->fields['label'] = new Widget_Form_Field_Input('label', '', 'Etykieta', array('style' => 'width: 300px', 'class' => 'first_input'));
        if ($this->new_file) {
            $this->fields['file'] = new Widget_Form_Field_File('file', 'Plik', array('style' => 'width: 300px'));
        }
        $this->apply_properties();
    }

    protected function prepare_buttons() {
        $this->buttons[] = new Widget_Form_Field_Submit('save', 'Zapisz', array('class' => 'button_white'));
        if (!$this->new_file) {
            $this->buttons[] = new Widget_Form_Field_Submit('back', 'Anuluj', array('class' => 'button_white'));
        }
    }

    protected function apply_properties() {
        $this->fields['label']->add_filters(array('trim'));
        $this->fields['label']->add_rules(array('not_empty'));
        if ($this->new_file) {
            $this->fields['file']->add_rules(array('Upload::not_empty'));
        }
    }

    protected function is_new_file_form($values) {
        return empty($values) OR empty($values['id']);
    }

}

?>
