<?php defined('SYSPATH') or die('No direct script access.');

class Form_Contact extends Widget_Form {
    
    private $translations = NULL;

    public function __construct($action = '', $values = array(), array $attributes = array(), $files = array()) {
	parent::__construct($action, $values, $attributes, $files);
        $this->translations = Kohana_Session::instance()->get('translate');
    }

    protected function prepare_buttons() {
        $this->buttons[] = new Widget_Form_Field_Submit('send', 'Wyślij', array('class' => 'button2'));
    }

    protected function prepare_fields() {
        $this->fields['name'] = new Widget_Form_Field_Input('name', '', $this->translations->LABEL_NAME_SURENAME, array('class' => 'txt first_input', 'style' => 'width: 200px'));
        $this->fields['email'] = new Widget_Form_Field_Input('email', '', 'E-mail', array('class' => 'txt', 'style' => 'width: 200px'));
        $this->fields['phone'] = new Widget_Form_Field_Input('phone', '', $this->translations->PHONE, array('class' => 'txt', 'style' => 'width: 200px'));
        $this->fields['security_code'] = new Widget_Form_Field_Input('security_code', '', $this->translations->SECURITY_CODE, array('class' => 'txt', 'style' => 'width: 76px', 'maxlength' => 5));
        //$this->fields['company'] = new Widget_Form_Field_Textarea('company', '', $this->translations->COMPANY, array('class' => 'txt', 'style' => 'width: 200px; height: 30px;'));
        //$this->fields['address'] = new Widget_Form_Field_Textarea('address', '', $this->translations->LABEL_adres, array('class' => 'txt', 'style' => 'width: 200px; height: 30px;'));
        $this->fields['message'] = new Widget_Form_Field_Textarea('message', '', $this->translations->MAIL_TEXT, array('class' => 'txt'));
        $this->apply_properties();
    }

    protected function apply_properties() {
        $this->fields['name']->add_filters(array('trim'));
        $this->fields['email']->add_filters(array('trim'));
        $this->fields['phone']->add_filters(array('trim'));
        $this->fields['security_code']->add_filters(array('trim'));
        //$this->fields['company']->add_filters(array('trim'));
        //$this->fields['address']->add_filters(array('trim'));
        $this->fields['message']->add_filters(array('trim'));
        $this->fields['name']->add_rules(array('not_empty'));
        $this->fields['email']->add_rules(array('not_empty', 'email'));
        $this->fields['phone']->add_rules(array('not_empty'));
        $this->fields['security_code']->add_rules(array('not_empty', 'Captcha::validate'));
        $this->fields['message']->add_rules(array('not_empty'));
    }

}

?>
