<?php defined('SYSPATH') or die('No direct script access.');

class Controller_XML extends Controller {

    protected $session = NULL;
    protected $selected_language = NULL;

    public function __construct(Kohana_Request $request) {
        parent::__construct($request);
        $this->session = Kohana_Session::instance();
        $this->selected_language = $this->get_selected_language();
    }

    public function action_index($id = null) {
        $sites = ORM::factory('Site_Middle')->where('content_sites_middle.language_id', '=', $this->selected_language)->get_tree();
        foreach ($sites as $site_id => $site) {
            $sites[$site_id]['image'] = $this->get_site_main_image($site['content_id']);
            if (isset($site['sub'])) {
                foreach ($site['sub'] as $subsite_id => $subsite) {
                    $sites[$site_id]['sub'][$subsite_id]['gallery'] = $this->get_site_gallery($subsite['content_id']);
                }
            }
        }
        $view = View::factory('xml');
        $view->sites = $sites;
        $view->translations = new Translation($this->selected_language);
        echo $view->render();
    }

    private function get_selected_language() {
        $session_lang = $this->session->get('application_language');
        if (!$session_lang) {
            if (isset($this->app['language_id'])) {
                $session_lang = $this->app['language_id'];
            } else {
                $session_lang = ORM::factory('Language')->find()->id;
            }
            $this->session->set('application_language', $session_lang);
        }
        return $session_lang;
    }

    private function get_site_main_image($id) {
        $image = ORM::factory('Gallery')->where('element_id', '=', $id)->find()->images->find();
        return $image->path . 'mid_' . $image->name;
    }

    private function get_site_gallery($id) {
        $images = ORM::factory('Gallery')->where('element_id', '=', $id)->find()->images->find_all();
        $gallery = array();
        foreach ($images as $image) {
            $gallery[] = $image->path . $image->name;
        }
        return $gallery;
    }

}

?>
