<?php defined('SYSPATH') or die('No direct script access.');

abstract class Controller_Template extends Kohana_Controller_Template {

    /**
     * @property simpleroles $roles_engine
     * @property authorize $authorize
     * @property simpleauth $authenticate
     */
    protected $username = 'niezalogowany';
    protected $roles_engine;
    protected $authorize;
    /**
     * @var Kohana_Session
     */
    protected $session;

    protected $operation_status = NULL;
    const OPERATION_UNDEFINED = 0;
    const OPERATION_SUCCESS = 1;
    const OPERATION_ERROR = 2;

    function __construct($request) {
        parent::__construct($request);
        $this->session = Kohana_Session::instance();
        $this->roles_engine = simpleauth::instance()->get_roles();
        $this->authorize = authorize::instance($this->roles_engine);
        $this->authenticate = simpleauth::instance();

        if (!$this->authorize->has_right($this->authenticate->get_user(), $this->get_access_path())) {
            throw new Exception('Nie masz praw dostepu do tego panelu: `' . $this->get_controller_name() . '` access_path: `' . $this->get_access_path() . '`.');
        }
    }

    protected function get_controller_name() {
        $name = get_class($this);
        $name = explode('_', $name);
        unset($name[0]);
        $name = implode('/', $name);
        return strtolower($name);
    }

    protected function get_access_path() {
        $controller_access_path = strtr($this->get_controller_name(), '/', '.');
        $controller_access_path = 'controller.' . $controller_access_path . '.access';
        return $controller_access_path;
    }

    protected function get_message_view() {
        if (isset($_GET['success'])) {
            if ($_GET['success']) {
                return new View_Message('Operacja została wykonana pomyślnie', 'message');
            } else {
                return new View_Message('Operacja nie powiodła się', 'error');
            }
        }
        return '';
    }

    protected function set_operation_status($flag = NULL) {
        if ($flag === NULL) {
            $this->operation_status = $this->guess_status_from_get();
        } else {
            $this->operation_status = $flag;
        }
    }

    private function guess_status_from_get() {
        if (!isset($_GET['success'])) {
            return NULL;
        } elseif ($_GET['success'] == 1) {
            return self::OPERATION_SUCCESS;
        } else {
            return self::OPERATION_ERROR;
        }
    }

    protected function redirect($controller_action, $status = 302) {
        $this->request->redirect($controller_action, $status);
    }

}

?>
