<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Site extends Controller_Frame {

    const MEDIA_SITE_ID = 9;

    private $site = NULL;

    public function __construct($request) {
        parent::__construct($request);
        FB::group(__FILE__);
        $this->site = ORM::factory('Site')
                ->where('content.id', '=', $this->request->param('id'))
                ->where('content_sites.language_id', '=', $this->selected_language)
                ->find();
    }

    public function before() {
        if ($this->site->id_parent > 0) {
            $parent = ORM::factory('Site')
                    ->where('content.id', '=', $this->site->id_parent)
                    ->where('content_sites.language_id', '=', $this->selected_language)
                    ->find();
            $this->title = ($parent->meta_title != '' ? $parent->meta_title . ' &bull; ' : '') . $this->title;
        }
        $this->title = ($this->site->meta_title != '' ? $this->site->meta_title . ' &bull; ' : '') . $this->title;
        $this->keywords = ($this->site->meta_keywords != '' ? $this->site->meta_keywords : $this->keywords);
        $this->description = ($this->site->meta_description != '' ? $this->site->meta_description : $this->description);
        parent::before();
    }

    public function action_index($id = null) {
        $view = View::factory('site');
        $view->name = $this->site->name;
        $view->body = $this->site->body;
        $view->item = $this->site;
        $view->contact = Option::factory('contact_' . $this->selected_language)->text2;
        $view->site_id = $this->site->content_id;
        $view->anchor = 'projects';
        $this->template->content = $view->render();
    }

    protected function get_site_images($content_id, $limit = 5) {
        if ($this->site->id_parent == 2) {
            return array();
        }
        return parent::get_site_images($content_id, $limit);
    }

    public function __destruct() {
        FB::groupEnd();
    }

}

?>
