<?php defined('SYSPATH') or die('No direct script access.');

abstract class Controller_Frame extends Controller_Template {
    const MENU_TOP_TEMPLATE = 'menu/top';
    const MAIN_CONTROLLER = 'main';
    protected $operation_status = NULL;
    /**
     * Nazwa strony internetowej
     */
    public $template = 'frame';
    /**
     *
     * @var Images
     */
    protected $images;
    /**
     * tytuł strony - belka przeglądarki
     * @var Top_Title
     */
    protected $title;
    /**
     * opis strony
     * @var Top_Description
     */
    protected $description;
    /**
     * słowa kluczowe
     * @var Top_Keywords
     */
    protected $keywords;
    /**
     *
     * @var Breadcrumb
     */
    protected $breadcrumb;
    /**
     * @var Translation
     */
    protected $translations = NULL;
    protected $selected_language = NULL;
    protected $gallery = NULL;
    protected $media = NULL;
    protected $partner = NULL;
    protected $projects = NULL;
    protected $realisations = NULL;
    protected $is_project_site = FALSE;

    public function __construct($request) {
        parent::__construct($request);
        $this->get_model();
        $this->images = new Images;
        $this->breadcrumb = new Breadcrumb();

        $this->selected_language = $this->get_selected_language();
        $this->translations = new Translation($this->selected_language);
        $this->session->set('translate', $this->translations);

        $this->set_operation_status();

        $meta_data = Option::factory('meta_1');
        $this->title = new Top_Title($meta_data['title']);
        $this->description = new Top_Description($meta_data['description']);
        $this->keywords = new Top_Keywords($meta_data['keywords']);
    }

    private function get_selected_language() {
        if (isset($_POST['change_admin_language'])) {
            $this->session->set('application_language', $_POST['change_admin_language']);
        }

        $session_lang = $this->session->get('application_language');
        if (!$session_lang) {
            if (isset($this->app['language_id'])) {
                $session_lang = $this->app['language_id'];
            } else {
                $session_lang = ORM::factory('Language')->find()->id;
            }
            $this->session->set('application_language', $session_lang);
        }
        return $session_lang;
    }

    protected function get_model() {
        return NULL;
    }

    protected function get_model_name() {
        return NULL;
    }

    public function before() {
        parent::before();
        $this->template->set_global('logged_in', $this->authenticate->logged_in());
        $this->template->set_global('images', $this->images);
        $this->template->set_global('translations', $this->translations);
        $this->template->set_global('logged_in', $this->authenticate->logged_in());
        $this->template->set_global('selected_language', $this->selected_language);
        $this->template->menu_top = ORM::factory('Site')->get_tree(0);
        $this->template->page_middle = $this->prepare_page_middle();
        
        $this->template->title = $this->title;
        $this->template->description = $this->description;
        $this->template->keywords = $this->keywords;
    }

    protected function prepare_page_middle() {
        $view = View::factory('middle');
        return $view->render();
    }

    public function after() {
        parent::after();
        $this->template->breadcrumb = $this->breadcrumb->render();
        $this->template->gallery = View::factory('site/gallery')
                ->set('items', $this->gallery)
                ->set('is_project_site', $this->is_project_site)
                ->render();
        $this->projects = $this->get_site_images(4, 20);
        $this->template->projects = View::factory('site/projects')
                ->set('items', $this->projects)
                ->set('name', $this->translations->LABEL_zobacz_przykladowe_projekty)
                ->render();
        $this->realisations = $this->get_site_images(5, 20);
        $this->template->realisations = View::factory('site/projects')
                ->set('items', $this->realisations)
                ->set('name', $this->translations->LABEL_zobacz_przykladowe_realizacje)
                ->render();
        $this->template->media = View::factory('site/media')
                ->set('items', $this->media)
                ->render();
        $this->template->partner = View::factory('site/partner')
                ->set('items', $this->partner)
                ->render();

        if ($this->request->status == 200 and $this->selected_language == 1) {
            Sitemap::instance()->add_uri(preg_replace('/^\//', '', $_SERVER['REQUEST_URI']));
        }
    }

    protected function get_site_images($content_id, $limit = 5) {
        return ($this->is_project_site ? array() : ORM::factory('Site')->where('content.id', '=', $content_id)->find()->gallery->images->order_by(DB::expr('RAND()'))->limit($limit)->find_all());
    }

    /**
     * Zwraca nazwę aktualnego kontrolera
     * @return string
     */
    public function get_controller_name() {
        return Text::last_word_in_underscored_string(get_class($this));
    }

    /**
     *  Zwraca nazwę aktualnego kontrolera pisaną małymi literami
     * @return string
     */
    public function get_controller_name_to_lower() {
        return UTF8::strtolower($this->get_controller_name());
    }

    protected function get_pagination($model) {
        $config = Kohana::config('pagination.site.' . $this->request->controller);
        if (empty($config)) {
            $config = Kohana::config('pagination.site.default');
        }
        $config['total_items'] = $model->get_count_all();
        $pagination = Pagination::factory($config, $this->request->controller);
        return $pagination;
    }

    protected function get_message_view() {
        return new Widget_Message($this->operation_status);
    }

    protected function get_id_and_controller_for_element($element) {
        return array('id' => $element['id'], 'controller' => $this->get_controller_name());
    }

}
?>

