<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Contact extends Controller_Frame {

    private $site = NULL;
    private $form = NULL;

    public function __construct($request) {
        parent::__construct($request);
        $this->form = new Form_Contact('contact', $_POST, array('id' => 'contact_form'));
        $this->message = $this->get_message_view();
        FB::group(__FILE__);
    }

    public function before() {
        $this->title = $this->translations->LABEL_KONTAKT . ' &bull; ' . $this->title;
        parent::before();
    }

    public function action_index($id = null) {
        $view = View::factory('contact');
        $view->body = Option::factory('contact_' . $this->selected_language)->text;
        
        if (isset($_POST['send'])) {
            if ($this->form->is_valid()) {
                if ($this->send_message($this->form->get_validated_array())) {
                    $this->request->redirect('contact?success=1');
                } else {
                    $this->message->set_text('Wysyłanie wiadomości nie powiodło się.');
                    $this->message->set_status(self::OPERATION_ERROR);
                }
            } else {
                $this->message = $this->form->get_errors();
            }
        }
        $view->email = Option::factory('contact_'.$this->session->get('application_language'))->email; 
        $view->form = $this->form;
        $view->message = $this->message;
        
        $this->template->content = $view->render();
    }
    
     private function send_message($message_data) {
        $result = Helper_Mailer::send_mail(
                        'message_contact_'.$this->session->get('application_language'), 
                $this->prepare_contact_message($message_data), 
                $message_data['email'], 
                str_replace('Imię i nazwisko', '', @$message_data['name']), 
                $this->get_contact_email(), 'http://www.materna-ossowska.pl/', 
                TRUE
        );

        if (count($result) > 0) {
            return true;
        }
        return false;
    }
    
    private function get_contact_email() {
        return Option::factory('contact_'.$this->session->get('application_language'))->email;
    }

    private function send_contact_message($form_values) {
        $option_message = Option::factory('message_contact_' . $this->session->get('application_language'));
        $recipients = array();
        $message = new Email_Message($option_message->title,
                        $this->get_message_styles() . $option_message->head . $this->prepare_contact_message($form_values) . $option_message->foot,
                        $this->get_contact_mail(),
                        'Porosa',
                        $this->get_contact_mail()
        );
        $mailer = new Email_Sender($message, array(
            $form_values['email'] => $form_values['name']
        ));
        $mailer->send();
        $message = new Email_Message($option_message->title,
                        $this->get_message_styles() . $option_message->head . $this->prepare_contact_message($form_values) . $option_message->foot,
                        $form_values['email'],
                        $form_values['name'],
                        $form_values['email']
        );
        $mailer = new Email_Sender($message, array(
             $this->get_contact_mail() => 'Porosa'
        ));
        $result = $mailer->send();
        if (count($result) > 0) {
            return true;
        }
        return false;
    }

    private function get_message_styles() {
        return '<style type="text/css">
    body {
        font-family: tahoma, helvetica, sans-serif, myriad-pro;
        font-size: 11px;
    }
</style>';
    }

    private function prepare_contact_message($values) {
        $body = "<br/><br/>";
        $body .= "<table width='600' cellspacing='0' cellpadding='3' border='1'><tr>";

        $body .= '<td>'.$this->translations->LABEL_NAME_SURENAME.':</td>';
        $body .= '<td>'.$values['name'].'</td>';
        $body .= "</tr><tr>";

        $body .= '<td>E-mail:</td>';
        $body .= '<td>'.$values['email'].'</td>';
        $body .= "</tr><tr>";

        $body .= '<td colspan="2">'.$this->translations->MAIL_TEXT.':</td>';
        $body .= "</tr><tr>";
        $body .= '<td colspan="2">'.$values['message'].'</td>';

        $body .= "</tr></table><br/><br/>";
        return $body;
    }

    protected function get_contact_mail() {
        $email = Option::factory('contact_' . $this->session->get('application_language'))->email;
        return ($email != '' ? $email : 'kancelaria@materna-ossowska.pl');
    }

    public function __destruct() {
        FB::groupEnd();
    }

}

?>
