<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_User extends Controller_Admin_Frame {
    const THIS_INDEX_PATH = 'admin/user/index/';
    const FORM_VIEW = 'common/form/titled';
    private $model_user;
    private $edit_form = NULL;
    private $page_number = 1;

    public function __construct($request) {
        parent::__construct($request);
        $this->message = $this->get_message_view();
        $this->model_user = new Model_User($this->request->param('id'));
        $this->page_number = $this->get_page_number_from_session_or_url();
    }

    /*private function get_page_number_from_session_or_url() {
        $page = 1;
        if (isset($_GET['page']) and $_GET['page'] > 1) {
            $page = $_GET['page'];
        } else {
            $page = (Kohana_Session::instance()->get('page_' . $this->request->controller) > 1 ? Kohana_Session::instance()->get('page_' . $this->request->controller) : 1);
        }
        return $page;
    }*/

    public function action_index() {
        $this->edit_form = new Form_User('admin/user/edit' . $this->create_page_query_string());
        $this->show_view($this->model_user);
    }

    private function create_page_query_string() {
        $query_string = '';
        if ($this->page_number > 1) {
            $query_string = '?page=' . $this->page_number;
        }
        return $query_string;
    }

    public function action_edit() {
        if (isset($_POST['submit'])) {
            $this->action_save();
        } else {
            $this->edit_form = new Form_User('admin/user/edit/' . $this->model_user->pk() . $this->create_page_query_string(), $this->model_user->as_array());
            $this->show_view($this->model_user);
        }
    }

    public function action_back($success = NULL) {
        $query_string = $this->create_page_query_string();
        if (!is_null($success)) {
            $success = (($query_string != '') ? '&' : '?') . 'success=' . $success;
        }
        $this->redirect('admin/user/index/' . $query_string . $success);
    }

    private function action_save() {
        $_POST['id'] = $this->model_user->pk();
        $this->edit_form = new Form_User('admin/user/edit/' . $this->model_user->pk() . $this->create_page_query_string(), $_POST);
        if ($this->edit_form->is_valid()) {
            $this->model_user->set_fields($this->edit_form->get_validated_array());
            $this->model_user->save();
            $this->action_back(1);
        } else {
            $this->message = new View_Message('Zapisanie danych nie powiodło się', 'error');
            $this->show_view();
        }
    }

    public function action_delete() {
        $success = '0';
        if ($this->model_user->pk() != simpleauth::instance()->get_user()->id AND $this->model_user->delete()) {
            $success = '1';
        }
        $this->action_back($success);
    }

    protected function show_view() {
        $content = (string) $this->get_user_view();
        $content .= (string) $this->get_view_list();
        $this->template->content = $this->get_message_view() . $content;
    }

    private function get_user_view() {
        $form = new Widget_Decorator_Title($this->edit_form);
        $form->set_view(self::FORM_VIEW);
        $form->set_title($this->set_view_title());
        return $form->render();
    }

    private function get_view_list() {
        $pagination = $this->get_pagination($this->model_user);
        $users = $this->model_user->get_range_as_items_array($pagination->get_offset(), $pagination->items_per_page);
        $users = $this->prepare_users($users);
        $columns = $this->get_column_names();
        $list_widget = Widget_List_Factory::get_list_widget(View::V_LIST, $columns, $users, $this->request->controller, $this->get_renderers());
        $list_widget->set_title('Lista użytkowników');
        $list_widget->set_pagination($pagination);
        return $list_widget->render();
    }

    private function get_renderers() {
        return array(
            array(
                'renderer' => 'Delete',
                'column' => 'delete',
                'row' => '*'
            ),
            array(
                'renderer' => 'Edit',
                'column' => 'edit',
                'row' => '*'
            ),
            array(
                'renderer' => 'Delete_Blocked',
                'column' => 'delete',
                'row' => array('role' => 2)
            )
        );
    }

    protected function get_column_names() {
        return array(
            'username' => Widget_List_Columns::get_column('', 'Nazwa użytkownika'),
            'email' => Widget_List_Columns::get_column('', 'E-mail(login)'),
            'last_time_stamp' => Widget_List_Columns::get_column('', 'Ostatnie logowanie', 'right'),
            'time_stamp_created' => Widget_List_Columns::get_column('', 'Data utworzenia konta', 'right'),
            'edit' => Widget_List_Columns::get_column(Widget_List_Columns::W_ACTION, Widget_List_Columns::L_EDIT, 'center'),
            'delete' => Widget_List_Columns::get_column(Widget_List_Columns::W_ACTION, Widget_List_Columns::L_DELETE, 'center'));
    }

    protected function prepare_users($users) {
        foreach ($users as &$user) {
            $user['delete'] = $this->get_id_and_controller_for_element($user);
            $user['edit'] = $this->get_id_and_controller_for_element($user);
        }
        return $users;
    }

    private function set_view_title() {
        if ($this->model_user->is_new()) {
            return 'Dodawanie użytkownika';
        } else {
            return 'Edycja użytkownika';
        }
    }

    public function action_change_password() {
        $form = new Form_User_Password(NULL, $_POST);

        if(isset($_POST['change_pass'])) {
            if($form->is_valid()) {
                $user = simpleauth::instance()->get_user();
                $save_arr = $form->get_validated_array();
                ORM::factory('User')->where('id', '=', $user->id)->find()->set_from_array($save_arr)->save();
                simpleauth::instance()->logout();
                simpleauth::instance()->login($user->email, $save_arr['password']);
                $this->redirect('admin/user/change_password?success=1');
            }
        }

        $form_view = new Widget_Decorator_Title($form);
        $form_view->set_view(self::FORM_VIEW);
        $form_view->set_title('Zmiana hasła');

        $this->template->content = $this->get_message_view() . $form_view->render();
    }

}
?>

