<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Site_Middle extends Controller_Admin_Site {

    protected $model_content = NULL;
    protected $list_title = 'Lista Stron - Menu środkowe';
    protected $new_item_uri = NULL;

    protected $content_name = 'Site_Middle';
    protected $translation_table = 'content_sites_middle';

    protected $max_lvl_number = 2;
    protected $current_lvl = 1;

    protected $block_del = array();

    public function __construct($request) {
        parent::__construct($request);
        if ($this->current_lvl == $this->max_lvl_number) {
            $this->new_item_uri = 'admin/site_middle/edit?parent=' . $_GET['parent'];
        }
    }

    protected function get_parents_path($parent = 0) {
        $path = array();
        $path[] = array('anchor' => 'admin/site_middle', 'name' => $this->list_title);
        if ($parent != 0) {
            $path = array_merge($path, $this->get_article_path_and_name($parent));
        }
        return $path;
    }

    public function action_image() {
        $this->redirect('admin/site_middle_image/'.$this->model_content->kind_id.'/'.$this->request->param('id').'/index');
        die;
    }

    protected function get_controller_name() {
        return 'admin/site_middle';
    }

    protected function get_renderers() {
        $renderers = array(
	    array(
		'renderer' => 'Edit',
		'column' => 'edit',
		'row' => '*'
	    ),
	    array(
		'renderer' => 'Sort',
		'column' => 'sort',
		'row' => '*'
	    )
	);
        if ($this->current_lvl == $this->max_lvl_number) {
            $renderers[] = array(
                'renderer' => 'Delete',
                'column' => 'delete',
                'row' => '*'
            );
        } else {
            $renderers[] = array(
                'renderer' => 'Common_Blocked',
                'column' => 'delete',
                'row' => '*'
            );
        }
        if($this->current_lvl < $this->max_lvl_number) {
            $renderers[] = array(
                'renderer' => 'Text_Subitems',
                'column' => 'name',
                'row' => '*'
            );
        }
        return $renderers;
    }

    protected function prepare_sites($sites) {
	foreach ($sites as &$site) {
            $id_and_controller = $this->get_id_and_controller_for_element($site);
            $site = $site->as_array();
            if($this->current_lvl < $this->max_lvl_number) {
                $id_and_controller['id'] = $site['content_id'];
                $site['name'] = array_merge(array('name' => $site['name']), $id_and_controller);
                $id_and_controller['id'] = $site['id'];
            }
	    $site['edit'] = $id_and_controller;
	    $site['delete'] = $id_and_controller;
	    $site['sort'] = $id_and_controller;
	}
	return $sites;
    }

    private function get_article_path_and_name($id) {
        $path = array();
        $article = ORM::factory('Site_Middle')->where('content_sites_middle.content_id', '=', $id)->find();
        if ($article->id_parent > 0) {
            $path = array_merge($path, $this->get_article_path_and_name($article->id_parent));
        }
        $path[] = array('anchor' => 'admin/site_middle/list?parent=' . $article->content_id, 'name' => $article->name);
        return $path;
    }

    protected function get_edit_view_title() {
	if ($this->model_content->is_new()) {
	    return 'Dodawanie Strony';
	} else {
	    return 'Edycja Strony';
	}
    }
    
    protected function get_tabs_view() {
        return Helper_Tabs::prepare_content_tabs('site_middle', $this->request->param('id'));
    }

}

?>
