<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Site_Media_Image extends Controller_Admin_Content {

    const VIEW = 'common/form/titled';
    protected $factory = NULL;
    protected $model_content = NULL;
    protected $list_title = 'Lista Artykułów';
    protected $new_item_uri = NULL;

    private $site = NULL;

    public function __construct($request) {
        parent::__construct($request);
        $this->site = ORM::factory('Site')->where('content_sites.id','=',$this->request->param('element_id'))->find();
        $this->new_item_uri = 'admin/site_media_image/'.$this->site->kind_id.'/'.$this->site->id.'/edit';
    }

    public function action_list() {
        $pagination = $this->get_pagination($this->model_content);
        $sites = $this->model_content->get_range_as_items_array($pagination->get_offset(), $pagination->items_per_page);
        $sites = $this->prepare_sites($sites);
        $columns = $this->get_column_names();
        $list_widget = Widget_List_Factory::get_list_widget(View::V_LIST, $columns, $sites, $this->request->controller, $this->get_renderers());
        $list_widget->set_title($this->list_title);
        $list_widget->set_uri($this->new_item_uri);
        $list_widget->set_anchor($this->images->{'files_dodajnowy.png'});
        $list_widget->set_pagination($pagination);
        $list_widget->set_breadcrumb($this->get_parents_path((int) @$_GET['parent']));

        $this->template->content = $this->get_message_view() . $this->render_tabs_view() . $list_widget->render();
    }

    public function action_edit() {
        if (isset($_POST['save'])) {
            $this->action_save();
        } elseif (isset($_POST['back'])) {
            $this->action_back();
            die;
        } else {
            $this->edit_form = new Form_Site_Media_Image($this->new_item_uri . '/' . $this->request->param('id'), $this->model_content->as_array(), array(), $_FILES);
            $this->show_view();
        }
    }

    protected function show_view() {
        $form = new Widget_Decorator_Title($this->edit_form);
        $form->set_view(self::VIEW);
        $form->set_title($this->get_edit_view_title());
        $this->template->content = $this->get_message_view() . $form->render();
    }

    public function action_save() {
        $_POST['id'] = $this->request->param('id');
        $this->edit_form = new Form_Site_Media_Image($this->new_item_uri . '/' . $this->request->param('id'), $_POST, array(), $_FILES);
        unset($_POST['id']);
        if ($this->edit_form->is_valid()) {
            $content_arr = array_merge(
                            $this->edit_form->get_validated_array(),
                            array('kind_id' => $this->model_content->get_content_kind_id())
            );
            switch ($content_arr['anchor_type']) {
                case 1:
                    $content_arr['anchor'] = $content_arr['anchor_text'];
                    break;
                case 2:
                    $content_arr['anchor'] = $content_arr['anchor_file'];
                    break;
            }
            $content_arr['site_id'] = $this->site->content_id;
            unset($content_arr['anchor_text']);
            unset($content_arr['anchor_file']);
            $this->model_content->values($content_arr);
            $this->model_content->save();
            $this->action_back(1);
            die;
        } else {
            $this->set_operation_status(self::OPERATION_ERROR);
            $this->show_view();
        }
    }

    public function action_back($success = NULL) {
        $query_string = $this->create_page_query_string();
        if (!is_null($success)) {
            $success = (($query_string != '') ? '&' : '?') . 'success=' . $success;
        }
        $this->redirect('admin/site_media_image/'.$this->site->kind_id.'/'.$this->site->id.'/list' . $query_string . $success);
    }

    protected function get_renderers() {
        return array(
	    array(
		'renderer' => 'Thumbnail',
		'column' => 'image',
		'row' => '*'
	    ),
	    array(
		'renderer' => 'Anchor',
		'column' => 'anchor',
		'row' => '*'
	    ),
	    array(
		'renderer' => 'Edit',
		'column' => 'edit',
		'row' => '*'
	    ),
	    array(
		'renderer' => 'Sort',
		'column' => 'sort',
		'row' => '*'
	    ),
            array(
                'renderer' => 'Delete',
                'column' => 'delete',
                'row' => '*'
            )
	);
    }

    protected function get_column_names() {
        return array(
	    'image' => Widget_List_Columns::get_column('', 'Logo'),
	    'anchor' => Widget_List_Columns::get_column('', 'Artykuł'),
	    'sort' => Widget_List_Columns::get_column(Widget_List_Columns::W_ACTION, 'Sort', 'right'),
	    'edit' => Widget_List_Columns::get_column(Widget_List_Columns::W_ACTION, Widget_List_Columns::L_EDIT, 'center'),
            'delete' => Widget_List_Columns::get_column(Widget_List_Columns::W_ACTION, Widget_List_Columns::L_DELETE, 'center')
        );
    }

    protected function prepare_sites($sites) {
        foreach ($sites as &$site) {
            $id_and_controller = $this->get_id_and_controller_for_element($site);
            $site['image'] = 'media/upload/media/' . $site['image'];
            $site['anchor'] = array(
                'label' => $site['anchor'],
                'anchor' => ($site['anchor_type'] == 1 ? $site['anchor'] : URL::base() . 'media/upload/media/' . $site['anchor']),
                'attributes' => array('target' => '_blank', 'style' => 'text-decoration: underline')
            );
	    $site['edit'] = $id_and_controller;
	    $site['delete'] = $id_and_controller;
	    $site['sort'] = $id_and_controller;
	}
	return $sites;
    }

    protected function get_controller_name() {
        $site = ORM::factory('Site')->where('content_sites.id','=',$this->request->param('element_id'))->find();
        return 'admin/site_media_image/' . $site->kind_id . '/' . $site->id;
    }

    protected function get_edit_view_title() {
        return 'Dodawanie artykułu';
    }

    protected function render_tabs_view() {
        $tabs = $this->get_tabs_view();
        $view = View::factory('admin/common/tabs');
        $view->tabs = $tabs;
        return $view->render();
    }

    protected function get_tabs_view() {
        $tabs = array();
        switch ($this->site->tabs_variant) {
            case 1:
                $tabs = $this->prepare_tabs('site');
                break;
            case 2:
                $tabs = $this->prepare_tabs('site_project');
                break;
            case 3:
                $tabs = $this->prepare_tabs('site_media');
        }
        return $tabs;
    }
    private function prepare_tabs($config = 'site') {
        $tabs = Helper_Tabs::prepare_content_tabs($config, $this->request->param('element_id'));
        foreach ($tabs as $tab_key => $tab_value) {
            $tabs[$tab_key]['anchor'] = str_replace($config, 'site', $tabs[$tab_key]['anchor']);
        }
        return $tabs;
    }

}

?>
