<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Site_Image extends Controller_Admin_Image {

    protected $controller_url = 'admin/site_image';

    protected function get_gallery_element_id() {
        return ORM::factory('Site')->translate_element_id_to_content_id($this->request->param('element_id'));
    }

    protected function get_parent_element_name() {
        return ORM::factory('Site')
                ->where('content.id', '=', $this->get_gallery_element_id())
                ->where('content_sites.language_id', '=', Kohana_Session::instance()->get('application_language'))
                ->find()->name;
    }

    protected function get_tabs_view() {
        return Helper_Tabs::prepare_content_tabs('site', $this->request->param('element_id'));
    }

}

?>
