<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Site extends Controller_Admin_Content_Translated {

    protected $model_content = NULL;
    protected $list_title = 'Lista Stron - Menu górne';
    protected $new_item_uri = 'admin/site/edit';

    protected $content_name = 'Site';
    protected $translation_table = 'content_sites';

    protected $max_lvl_number = 1;
    protected $current_lvl = 1;

    protected $block_del = array(1,2,3,4,5);

    public function __construct($request) {
        parent::__construct($request);
        $this->current_lvl = count($this->get_parents_path((int) @$_GET['parent']));
    }

    protected function get_parents_path($parent = 0) {
        $path = array();
        $path[] = array('anchor' => 'admin/site', 'name' => $this->list_title);
        if ($parent != 0) {
            $path = array_merge($path, $this->get_article_path_and_name($parent));
        }
        return $path;
    }

    public function action_image() {
        $this->redirect('admin/site_image/'.$this->model_content->kind_id.'/'.$this->request->param('id').'/index');
        die;
    }

    public function action_media_image() {
        $this->redirect('admin/site_media_image/'.$this->model_content->kind_id.'/'.$this->request->param('id').'/list');
        die;
    }

    public function action_project_image() {
        $this->redirect('admin/site_project_image/'.$this->model_content->kind_id.'/'.$this->request->param('id').'/index');
        die;
    }

    protected function get_renderers() {
        $renderers = array(
	    array(
		'renderer' => 'Edit',
		'column' => 'edit',
		'row' => '*'
	    ),
	    array(
		'renderer' => 'Sort',
		'column' => 'sort',
		'row' => '*'
	    )
            
	);
//        if($this->current_lvl == 1) {
//            $renderers[] = array(
//                'renderer' => 'Common_Blocked',
//                'column' => 'delete',
//                'row' => '*'
//            );
//        } else {
            $renderers[] = array(
                'renderer' => 'Delete',
                'column' => 'delete',
                'row' => '*'
            );
//        }
        if($this->current_lvl < $this->max_lvl_number) {
            $renderers[] = array(
                'renderer' => 'Text_Subitems',
                'column' => 'name',
                'row' => array('content_id' => 2)
            );
        }
        $renderers[] = array(
                'renderer' => 'Common_Blocked',
                'column' => 'delete',
                'row' => array('id' => array(19,20))
            );
        
        return $renderers;
    }

    protected function get_column_names() {
	$columns = array(
	    'name' => Widget_List_Columns::get_column('', 'Nazwa Strony'),
	    'sort' => Widget_List_Columns::get_column(Widget_List_Columns::W_ACTION, 'Sort', 'right'),
	    'edit' => Widget_List_Columns::get_column(Widget_List_Columns::W_ACTION, Widget_List_Columns::L_EDIT, 'center')
        );
            $columns['delete'] = Widget_List_Columns::get_column(Widget_List_Columns::W_ACTION, Widget_List_Columns::L_DELETE, 'center');
        if ($this->current_lvl > 1) {
        }
        return $columns;
    }

    protected function prepare_sites($sites) {
	foreach ($sites as &$site) {
            $id_and_controller = $this->get_id_and_controller_for_element($site);
            $site = $site->as_array();
            if($this->current_lvl < $this->max_lvl_number and $site['content_id'] == 2) {
                $id_and_controller['id'] = $site['content_id'];
                $site['name'] = array_merge(array('name' => $site['name']), $id_and_controller);
                $id_and_controller['id'] = $site['id'];
            }
	    $site['edit'] = $id_and_controller;
	    $site['delete'] = $id_and_controller;
	    $site['sort'] = $id_and_controller;
	}
	return $sites;
    }

    /**
     * Funkcja zwraca informacje potrzebne rendererowi typu Widget_Renderer_Sort
     * @param array $element wiersz do przygotowania
     * @return array dane do przygotowania renderera sort;
     */
    protected function get_info_for_sort_element($element) {
	$values = $this->get_id_and_controller_for_element($element);
	$pagination = $this->get_pagination($this->model_content);
	$values['old_sort'] = $element['sort'];
	$values['max_sort'] = $pagination->total_items;
	return $values;
    }

    private function get_article_path_and_name($id) {
        $path = array();
        $article = ORM::factory('Site')->where('content_sites.content_id', '=', $id)->find();
        if ($article->id_parent > 0) {
            $path = array_merge($path, $this->get_article_path_and_name($article->id_parent));
        }
        $path[] = array('anchor' => 'admin/site/list?parent=' . $article->content_id, 'name' => $article->name);
        return $path;
    }

    protected function get_edit_view_title() {
	if ($this->model_content->is_new()) {
	    return 'Dodawanie Strony';
	} else {
	    return 'Edycja Strony';
	}
    }
    
     public function action_files() {
        $this->redirect('admin/site_file/'.$this->model_content->kind_id.'/'.$this->request->param('id').'/index');
        die;
    }
    
    protected function get_tabs_view() {
        $tabs = array();
        switch ($this->model_content->tabs_variant) {
            case 1:
                $tabs = $this->prepare_tabs('site');
                break;
            case 2:
                $tabs = $this->prepare_tabs('site_project');
                break;
            case 3:
                $tabs = $this->prepare_tabs('site_media');
        }
        return $tabs;
    }
    private function prepare_tabs($config = 'site') {
        $tabs = Helper_Tabs::prepare_content_tabs($config, $this->request->param('id'));
        foreach ($tabs as $tab_key => $tab_value) {
            $tabs[$tab_key]['anchor'] = str_replace($config, 'site', $tabs[$tab_key]['anchor']);
        }
        return $tabs;
    }

}

?>
