<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Settings_Main extends Controller_Admin_Settings {

    protected $controller_address = 'admin/settings_main';
    protected $form_class_name = 'Form_Settings_Main';
    protected $form = NULL;
    protected $errors;
    protected $title = 'Ustawienia - Strona Główna';

    protected function get_options() {
        return Option::factory('main_' . $this->session->get('application_language'));
    }

    public function action_save() {
        $this->form = new $this->form_class_name($this->controller_address . '/save', array_merge($_POST,$_FILES));
        if ($this->form->is_valid()) {
            $option = $this->get_options();
            $option_arr = $this->form->get_validated_array();
            $option->from_array($option_arr);
            $option->save();
            $this->redirect($this->controller_address . '/?success=1');
        } else {
            $this->setup_template();
        }
    }

    private function upload_foto($file) {
        $option = $this->get_options();
        $old_foto = $option['foto'];
        if($old_foto != '') {
            // miniaturki !!!
            unlink('media/upload/main/'.$old_foto);
        }
        $filename = Upload::save($file, $file['name'], 'media/upload/main/');
        $filename = explode(DIRECTORY_SEPARATOR, $filename);
        return end($filename);
    }

}

?>
