<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Settings extends Controller_Admin_Frame {

    protected $controller_address = NULL;
    protected $form_class_name = NULL;
    protected $view = 'common/form/titled';
    protected $title = NULL;

    public function __construct($request) {
        parent::__construct($request);
        $this->message = $this->get_message_view();
    }

    public function action_index() {
        $form_values = $this->get_options()->as_array();
        $this->form = new $this->form_class_name($this->controller_address.'/save', $form_values);
        $this->setup_template();
    }

    protected function get_options() {
        return NULL;
    }

    public function action_save() {
        $this->form = new $this->form_class_name($this->controller_address.'/save', $_POST);
        if ($this->form->is_valid()) {
            $option = $this->get_options();
            $option->from_array($this->form->get_validated_array());
            $option->save();
            $this->redirect($this->controller_address.'/?success=1');
        } else {
            $this->setup_template();
        }
    }

    private function setup_template() {
        $form = new Widget_Decorator_Title($this->form);
        $form->set_view($this->view);
        $form->set_title($this->title);
        $this->template->content = $this->get_message_view() . $form->render();
    }

}

?>
