<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Partner extends Controller_Admin_Content_Translated {

    protected $model_content = NULL;
    protected $list_title = 'Lista partnerów';
    protected $new_item_uri = 'admin/partner/edit';

    protected $content_name = 'partner';
    protected $translation_table = 'content_partner';

    protected function get_renderers() {
        return array(
            array(
                'renderer' => 'Thumbnail',
                'column' => 'image',
                'row' => '*'
            ),
	    array(
		'renderer' => 'Edit',
		'column' => 'edit',
		'row' => '*'
	    ),
            array(
                'renderer' => 'Delete',
                'column' => 'delete',
                'row' => '*'
            )
	);
    }

    protected function get_column_names() {
	return array(
            'image' => Widget_List_Columns::get_column('200', 'Logotyp', 'center'),
	    'name' => Widget_List_Columns::get_column('', 'Nazwa'),
	    'edit' => Widget_List_Columns::get_column(Widget_List_Columns::W_ACTION, Widget_List_Columns::L_EDIT, 'center'),
            'delete' => Widget_List_Columns::get_column(Widget_List_Columns::W_ACTION, Widget_List_Columns::L_DELETE, 'center'));
    }

    protected function prepare_sites($sites) {
        $items = array();
        foreach ($sites as $site) {
            $items[] = $site->as_array();
        }
        $sites = $items;
	foreach ($sites as &$site) {
            $id_and_controller = $this->get_id_and_controller_for_element($site);
            $site['image'] = ($site['image'] != '' ? 'media/upload/partner/' . $site['image'] : '');
	    $site['edit'] = $id_and_controller;
	    $site['delete'] = $id_and_controller;
	}
	return $sites;
    }

    protected function get_edit_view_title() {
	if ($this->model_content->is_new()) {
	    return 'Dodawanie Partnera';
	} else {
	    return 'Edycja Partnera';
	}
    }

}

?>
