<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Message extends Controller_Admin_Frame {

    private $message_names = array(
        1=> 'contact'
    );

    public function action_index() {
        $columns = $this->get_column_names();
        $items = $this->get_messages_list();
        $list_widget = Widget_List_Factory::get_list_widget(View::V_LIST, $columns, $items, $this->request->controller, $this->get_renderers());
        $list_widget->set_title('Lista wiadomości');
        $this->template->content = $this->get_message_view() . $list_widget->render();
    }

    public function action_edit() {
        if (!$this->request->param('id')) {
            $this->redirect('admin/message');
            die;
        }

        $message_name = $this->message_names[$this->request->param('id')];
        $message = Option::factory('message_' . $message_name . '_' . $this->session->get('application_language'));

        $form = new Form_Message(NULL, (isset($_POST['save']) ? $_POST : $message->as_array()));

        if (isset($_POST['save'])) {
            if ($form->is_valid()) {
                $message->from_array($form->get_validated_array());
                $message->save();
                $this->redirect('admin/message');
                die;
            }
        }

        $form_view = new Widget_Decorator_Title($form);
        $form_view->set_view('common/form/titled');
        $form_view->set_title('Edycja wiadomości');
        $this->template->content = $this->get_message_view() . $form_view->render();
    }

    private function get_messages_list() {
        $messages = array();
        $id_and_controller = $this->get_id_and_controller_for_element(NULL);
        foreach ($this->message_names as $message_id => $message_name) {
            $messages[] = array(
                'name' => Option::factory('message_' . $message_name . '_' . $this->session->get('application_language'))->title,
                'edit' => array(
                    'id' => $message_id,
                    'controller' => 'admin/message'
                )
            );
        }
        return $messages;
    }

    protected function get_renderers() {
        return array(
	    array(
		'renderer' => 'Edit',
		'column' => 'edit',
		'row' => '*'
	    )
	);
    }

    protected function get_column_names() {
	return array(
	    'name' => Widget_List_Columns::get_column('', 'Tytuł Wiadomości'),
	    'edit' => Widget_List_Columns::get_column(Widget_List_Columns::W_ACTION, Widget_List_Columns::L_EDIT, 'center'));
    }

}

?>
