<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Login extends Controller_Admin_Authcore {
    const ACTION_LOGIN='admin/login';
    const ACTION_DEFAULT='admin';
    const VIEW_LOGIN='admin/login';
    public $template = self::ACTION_LOGIN;

    public function action_index() {
        $this->if_logged_redirect_to(self::ACTION_DEFAULT);
        $this->template = new View(self::VIEW_LOGIN);
        $submit = isset($_POST['submit']);
        if ($this->prepare_and_validate($submit)) {
            $this->login_to();
        }
        $this->form_populate_view($submit);
    }

    private function prepare_and_validate($submit) {
        $this->form_post = Validate::factory($_POST)->filter(TRUE, 'trim');
        $this->make_field('username', array('not_empty'));
        $this->make_field('password', array('not_empty'));
        if ($submit AND $this->validate()) {
            $this->set_fields($submit);
            return TRUE;
        }
        return FALSE;
    }

    private function if_logged_redirect_to($controller_action) {
        if (simpleauth::instance()->logged_in()) {
            $this->template = self::ACTION_DEFAULT;
            $this->redirect($controller_action);
            die;
        }
    }

    private function login_to() {
        if (simpleauth::instance()->login($this->form_post['username'], $this->form_post['password'])) {
            $this->redirect(self::ACTION_DEFAULT);
            die;
        } else {
            $this->form_errors['username'] = 'Niepoprawna nazwa użytkownika lub hasło';
        }
    }

    public function action_logout() {
        simpleauth::instance()->logout();
        $this->redirect(self::ACTION_LOGIN);
        $this->action_index();
        exit;
    }

    public function after() {
        $r = parent::after();
        if (!isset($this->template->content)) {
            $this->template->content = '';
        }
        $view_header = new View('admin/header');
        $this->template->set_global('header', $view_header);
        return $r;
    }

}
?>

