<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Language extends Controller_Admin_Frame {

    const EDIT_VIEW = 'common/form/titled';
    protected $model = NULL;
    protected $list_title = 'Lista Języków';
    protected $new_item_uri = NULL; //'admin/language/edit/';
    
    public function __construct($request) {
        parent::__construct($request);
        $this->factory = new Factory($this->request->controller);
        $this->model = $this->factory->get_orm($this->request->param('id'));
        $this->message = $this->get_message_view();
        $this->page_number = $this->get_page_number_from_session_or_url();
        $this->new_item_uri .= ( (int) @$_GET['parent'] > 0 ? '?parent=' . (int) @$_GET['parent'] : '');
    }

    public function action_index() {
        $pagination = $this->get_pagination($this->model);
        $sites = $this->model->get_range_as_items_array($pagination->get_offset(), $pagination->items_per_page);
        $sites = $this->prepare_sites($sites);
        $columns = $this->get_column_names();
        $list_widget = Widget_List_Factory::get_list_widget(View::V_LIST, $columns, $sites, $this->request->controller, $this->get_renderers());
        $list_widget->set_title($this->list_title);
        $list_widget->set_uri($this->new_item_uri);
        $list_widget->set_anchor($this->images->{'files_dodajnowy.png'});
        $list_widget->set_pagination($pagination);

        $this->template->content = $this->get_message_view() . $list_widget->render();
    }
    
    public function action_edit() {
        if ($this->new_item_uri == NULL) {
            $this->redirect('admin/language', 400);
            die;
        }
        if (isset($_POST['save'])) {
            $this->action_save();
        } elseif (isset($_POST['back'])) {
            $this->action_back();
            die;
        } else {
            $this->edit_form = $this->factory->get_form($this->request->param('id'), $this->model->as_array());
            $this->show_view();
        }
    }

    private function show_view() {
        $form = new Widget_Decorator_Title($this->edit_form);
        $form->set_view(self::EDIT_VIEW);
        $form->set_title($this->get_edit_view_title());
        $this->template->content = $this->get_message_view() . $form->render();
    }

    public function action_save() {
        $_POST['id'] = $this->request->param('id');
        $this->edit_form = $this->factory->get_form($this->request->param('id'), $_POST);
        unset($_POST['id']);
        if ($this->edit_form->is_valid()) {
            $this->model->set_from_array($this->edit_form->get_validated_array());
            $this->model->save();
            $this->action_back(1);
        } else {
            $this->set_operation_status(self::OPERATION_ERROR);
            $this->show_view();
        }
    }

    public function action_back($success = NULL) {
        $query_string = $this->create_page_query_string();
        if (!is_null($success)) {
            $query_string .= (($query_string != '') ? '&' : '?') . 'success=' . $success;
        }
        $this->redirect('admin/' . $this->request->controller . ($query_string != '' ? '/index/' . $query_string : ''));
    }

    private function create_page_query_string() {
        $query_string = '';
        $qs_elements = array();
        if ($this->page_number > 1) {
            //$query_string = '?page=' . $this->page_number;
            $qs_elements[] = 'page=' . $this->page_number;
        }
        if (isset($_GET['parent']) and $_GET['parent'] > 0) {
            //$query_string .= ( strlen($query_string) > 0 ? '&' : '?') . 'parent=' . $_GET['parent'];
            $qs_elements[] = 'parent=' . $_GET['parent'];
        }
        $query_string = (count($qs_elements) ? '?' : '') . implode('&', $qs_elements);
        return $query_string;
    }

    protected function get_renderers() {
        return array(
	    array(
		'renderer' => 'Edit',
		'column' => 'edit',
		'row' => '*'
	    )
	);
    }

    protected function get_column_names() {
	return array(
	    'short_name' => Widget_List_Columns::get_column(Widget_List_Columns::W_ACTION, 'Skrót', 'center'),
	    'name' => Widget_List_Columns::get_column('', 'Nazwa Języka'),
	    'edit' => Widget_List_Columns::get_column(Widget_List_Columns::W_ACTION, Widget_List_Columns::L_EDIT, 'center'));
    }

    protected function prepare_sites($sites) {
	foreach ($sites as &$site) {
            $id_and_controller = $this->get_id_and_controller_for_element($site);
	    $site['edit'] = $id_and_controller;
	}
	return $sites;
    }

    /**
     * Funkcja zwraca informacje potrzebne rendererowi typu Widget_Renderer_Sort
     * @param array $element wiersz do przygotowania
     * @return array dane do przygotowania renderera sort;
     */
    protected function get_info_for_sort_element($element) {
	$values = $this->get_id_and_controller_for_element($element);
	$pagination = $this->get_pagination($this->model);
	$values['old_sort'] = $element['sort'];
	$values['max_sort'] = $pagination->total_items;
	return $values;
    }

    private function get_article_path_and_name($id) {
        $path = array();
        $article = ORM::factory('Site')->where('content_sites.id', '=', $id)->find();
        if ($article->id_parent > 0) {
            $path = array_merge($path, $this->get_article_path_and_name($article->id_parent));
        }
        $path[] = array('anchor' => 'admin/language/list?parent=' . $id, 'name' => $article->name);
        return $path;
    }

    protected function get_edit_view_title() {
	if ($this->model->is_new()) {
	    return 'Dodawanie Języka';
	} else {
	    return 'Edycja Języka';
	}
    }

}

?>
