<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Frame extends Controller_Template {

    public $template = 'admin/frame';
    protected $message = '';
    protected $images = '';
    protected $translations = '';

    const OPERATION_UNDEFINED = 0;
    const OPERATION_SUCCESS = 1;
    const OPERATION_ERROR = 2;
    protected $operation_status = NULL;

    protected $selected_language = NULL;

    public function __construct($request) {
        parent::__construct($request);
        if ($this->authenticate->logged_in()) {
            $this->username = $this->authenticate->get_user()->username;
        } else {
            $this->request->redirect('admin/login', 401);
        }

        $this->images = new Images;

        $this->selected_language = $this->get_selected_language();
        $this->translations = new Translation($this->selected_language);
        $this->set_operation_status();

        FB::group('user');
        FB::log($this->authenticate->get_user()->as_array());
        FB::groupEnd();
    }

    public function before() {
        parent::before();

        $view_header = $this->get_view('admin/header');
        $this->template->header = $view_header;
        $this->template->languages = ORM::factory('Language')->get_all_as_selectbox_list();
        $this->template->selected_language = $this->selected_language;
        $this->template->username = $this->username;
        $this->template->admin_menu = new Widget_Menu_Access('admin/menu', 'admin/menu', 'menu.admin');
        $this->template->set_global('images', $this->images);
        $this->template->set_global('translations', $this->translations);
    }

    private function get_selected_language() {
        if(isset($_POST['change_admin_language'])) {
            $this->session->set('application_language', $_POST['change_admin_language']);
        }

        $session_lang = $this->session->get('application_language');
        if(!$session_lang) {
            $session_lang = ORM::factory('Language')->find()->id;
            $this->session->set('application_language', $session_lang);
        }
        return $session_lang;
    }

    protected function get_view($file) {
        return View::factory($file);
    }

    protected function get_message_view() {
        return new Widget_Message($this->operation_status);
    }

    protected function get_pagination($model) {
        $config = Kohana::config('pagination.' . $this->request->controller);
        if (empty($config)) {
            $config = Kohana::config('pagination.default');
        }
        $config['total_items'] = $model->get_count_all();
        $pagination = Pagination::factory($config, $this->request->controller);
        return $pagination;
    }

    protected function get_id_and_controller_for_element($element) {
        return array('id' => $element['id'], 'controller' => $this->get_controller_name());
    }

    protected function set_operation_status($flag = NULL) {
        if ($flag === NULL) {
            $this->operation_status = $this->guess_status_from_get();
        } else {
            $this->operation_status = $flag;
        }
    }

    private function guess_status_from_get() {
        if (!isset($_GET['success'])) {
            return NULL;
        } elseif ($_GET['success'] == 1) {
            return self::OPERATION_SUCCESS;
        } else {
            return self::OPERATION_ERROR;
        }
    }

    protected function get_page_number_from_session_or_url() {
	$page = 1;
	if (isset($_GET['page']) and $_GET['page'] > 1) {
	    $page = $_GET['page'];
	} else {
	    $page = (Kohana_Session::instance()->get('page_' . $this->request->controller) > 1 ? Kohana_Session::instance()->get('page_' . $this->request->controller) : 1);
	}
	return $page;
    }

}
?>

