<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_File extends Controller_Admin_Frame {
    const CONTROLLER_URL = 'admin/file';
    const VIEW = 'common/form/titled';
    protected $repository = null;
    protected $form = null;
    protected $message = null;
    protected $action = null;
    protected $fid = null;
    protected $repository_string;
    protected $controller_url = 'admin/file';

    public function __construct($request) {
        parent::__construct($request);
        $this->fid = $this->request->param('id');

        if ($this->fid == FALSE) {
            $this->action = 'new';
        } else {
            $this->action = 'index';
        }

        $this->message = $this->message = $this->get_message_view();
        $this->init_repository_from_request();
        $this->repository_string = $this->repository->repository_kind_id . '/' . $this->request->param('element_id');
        $this->page_number = $this->get_page_number_from_session_or_url();
    }

    protected function get_repository_element_id() {
        return ORM::factory('Site')->translate_element_id_to_content_id($this->request->param('element_id'));
    }

    protected function create_page_query_string() {
        $query_string = '';
        if ($this->page_number > 1) {
            $query_string = '?page=' . $this->page_number;
        }
        return $query_string;
    }

    public function action_index() {
        $orm = $this->repository->get_element();
        if (isset($_POST['back'])) {
            $this->action_back();
        }
        if (isset($_POST['save'])) {
            $this->action_save();
        } else {
            $file = ORM::factory('File', $this->fid);
            $this->form = $this->prepare_form($file->as_array());
            $this->show_view();
        }
    }

    public function action_back($success = NULL) {
        $query_string = $this->create_page_query_string();
        if (!is_null($success)) {
            $success = (($query_string != '') ? '&' : '?') . 'success=' . $success;
        }
        $this->redirect($this->controller_url . '/' . $this->repository_string . '/index/' . $query_string . $success);
    }

    public function action_save() {
        $file = ORM::factory('File', $this->fid);
        $_POST['id'] = $this->request->param('id');
        $this->form = $this->prepare_form($_POST, $_FILES);
        if ($this->form->is_valid()) {
            if ($this->action == 'new') {
                $form_values = $this->form->get_validated_array();
                $file = $form_values['file'];
                unset($form_values['file']);
                $this->repository->save_file($file, $form_values);
            } else {
                $file->values($this->form->get_validated_array());
                $file->save();
            }
            $this->action_back(1);
        } else {
            $this->message = new View_Message('Zapisanie danych nie powiodło się', 'error');
            $this->show_view();
        };
    }

    /*public function action_edit() {
        $this->template->content = 'edycja';
    }*/

    public function action_delete() {
        $file = ORM::factory('File', $this->fid);
        $file->delete();
        $this->action_back(1);
    }

    protected function init_repository_from_request() {
        $this->repository = new Model_Repository(array(
                    'kind_id' => (int) $this->request->param('kind_id'),
                    'element_id' => (int) $this->get_repository_element_id()
                ));

        if ($this->repository->pk() == FALSE) {
            //if repository could not be inited from kind and element _id try
            //first repository for the file
            $file = ORM::factory('File', $this->fid);
            if ($file->pk() == TRUE) {
                $this->repository = $file->repository->find();
            }
        }
        if ($this->repository->pk() == FALSE) {
            //if there was a problem getting the repo try going back to
            //the default model view
            $repo_kind = ORM::factory('repository_kind', $this->request->param('kind_id'));
            throw new Exception('Repozytorium nieznalezione');
            $this->redirect('admin/' . $repo_kind->name, 400);
        }
    }

    protected function show_view() {
        $content = (string) $this->get_form_view();
        $content .= (string) $this->get_list_view($this->repository);
        $this->template->content = $this->render_tabs_view() . $content;
    }

    protected function render_tabs_view() {
        $view = View::factory('admin/common/tabs');
        $view->tabs = $this->get_tabs_view();
        return $view->render();
    }

    protected function get_tabs_view() {
        return NULL;
    }

    protected function get_form_view() {
        $form = new Widget_Decorator_Title($this->form);
        $form->set_view(self::VIEW);
        $form->set_title($this->get_view_title());
        return $form->render();
    }

    private function get_list_view() {
        $pagination = $this->get_pagination($this->repository->files);
        $files = $this->repository->files->get_range_as_items_array($pagination->get_offset(), $pagination->items_per_page);
        $files = $this->prepare_files($files);
        $columns = $this->get_column_definitions();

        $kind = $this->repository->repository_kind->human_name;
        $name = $name = $this->get_parent_element_name();

        $list_widget = Widget_List::factory(View::V_LIST, $columns, $files, 'files');
        $list_widget->set_title('Lista plików dla ' . $kind . ': "' . $name . '"');
        $list_widget->set_pagination($pagination);
        $list_widget->set_renderer('Delete', 'delete', '*');
        $list_widget->set_renderer('Edit', 'edit', '*');

        return $list_widget->render();
    }

    protected function prepare_files($files) {
        foreach ($files as &$file) {
            $file['delete'] = $this->get_id_and_controller_for_element($file);
            $file['edit'] = $this->get_id_and_controller_for_element($file);
        }
        return $files;
    }
    
    protected function  get_id_and_controller_for_element($element) {
        $id_and_controller = parent::get_id_and_controller_for_element($element);
        $id_and_controller['controller'] .= '/' . $this->request->param('kind_id') . '/' . $this->request->param('element_id');
        return $id_and_controller;
    }

    protected function get_controller_name() {
        return $this->controller_url;
    }

    protected function get_list_pagination() {
        //prepare pagination complicated due to many-to-many relation
        $config = Kohana::config('pagination.default');
        $config['total_items'] = $this->repository->files->count_all();
        $pagination = Pagination::factory($config);
        return $pagination;
    }

    protected function get_list_elements($pagination) {
        //prepare elements for list; complicated due to many-to-many relation
        return $this->repository->files->offset($pagination->get_offset())->limit($pagination->items_per_page)->find_all();
    }

    protected function get_column_definitions() {
        return array(
            'name' => Widget_List_Columns::get_column('', 'Nazwa pliku'),
            'label' => Widget_List_Columns::get_column('', 'Etykieta'),
            'edit' => Widget_List_Columns::get_column(Widget_List_Columns::W_ACTION, Widget_List_Columns::L_EDIT, 'center'),
            'delete' => Widget_List_Columns::get_column(Widget_List_Columns::W_ACTION, Widget_List_Columns::L_DELETE, 'center')
        );
    }

    /**
     * @param array $object_array
     * @param boolean $validate
     * @return <type>
     */
    protected function prepare_form($object_array = array(), $files = array()) {
        return new Form_File($this->controller_url . '/' . $this->repository_string . '/index/' . $this->request->param('id') . $this->create_page_query_string(), $object_array, array(), $files);
    }

    protected function get_view_title() {
        if ($this->action == 'new') {
            return 'Dodaj nowy plik';
        } else {
            return 'Edytuj dane pliku';
        }
    }

    protected function is_ok($errors) {
        return empty($errors);
    }

    /// Access section

    protected function get_access_action() {
        if (isset($_POST['save'])) {
            return 'save';
        }
        return parent::get_access_action();
    }

    protected function user_is_owner_of_action_object() {
        $repo_owner = $this->repository->get_owner_model();
        $user = $repo_owner->get_owner_model();
        return ($user !== NULL AND $user->pk() == simpleauth::instance()->get_user()->pk());
    }


}

?>
