<?php defined('SYSPATH') or die('No direct script access.');

abstract class Controller_Admin_Content_Translated extends Controller_Admin_Frame {
    
    const VIEW = 'common/form/titled';
    protected $factory = NULL;
    protected $model_content = NULL;
    protected $edit_form = NULL;
    protected $list_title = NULL;
    protected $new_item_uri = NULL;
    protected $content_name = NULL;
    protected $translation_table = NULL;
    protected $content_id = NULL;

    public function __construct($request) {
        parent::__construct($request);
        $this->content_name = $this->request->controller;
        $this->factory = new Factory($this->content_name);
        $this->content_id = ORM::factory($this->content_name)->where($this->translation_table . '.id', '=', $this->request->param('id'))->find()->content_id;
        $this->message = $this->get_message_view();
        $this->page_number = $this->get_page_number_from_session_or_url();
        $this->new_item_uri .= ( (int) @$_GET['parent'] > 0 ? '?parent=' . (int) @$_GET['parent'] : '');
        $this->model_content = $this->factory->get_orm($this->request->param('id'));
    }

    private function create_page_query_string() {
        $query_string = '';
        $qs_elements = array();
        if ($this->page_number > 1) {
            $qs_elements[] = 'page=' . $this->page_number;
        }
        if (isset($_GET['parent']) and $_GET['parent'] > 0) {
            $qs_elements[] = 'parent=' . $_GET['parent'];
        }
        $query_string = (count($qs_elements) ? '?' : '') . implode('&', $qs_elements);
        return $query_string;
    }

    public function action_index() {
        Kohana_Session::instance()->delete('page_' . $this->request->controller);
        $this->redirect('admin/' . $this->request->controller . '/list');
    }

    public function action_back($success = NULL) {
        $query_string = $this->create_page_query_string();
        if (!is_null($success)) {
            $success = (($query_string != '') ? '&' : '?') . 'success=' . $success;
        }
        $this->redirect('admin/' . $this->request->controller . '/list/' . $query_string . $success);
    }

    public function action_list() {
        $pagination = $this->get_pagination($this->model_content);
        $sites = $this->model_content->get_range($pagination->get_offset(), $pagination->items_per_page);
        $sites = $this->prepare_sites($sites->as_array());
        $columns = $this->get_column_names();
        $list_widget = Widget_List_Factory::get_list_widget(View::V_LIST, $columns, $sites, $this->request->controller, $this->get_renderers());
        $list_widget->set_title($this->list_title);
        $list_widget->set_uri($this->new_item_uri);
        $list_widget->set_anchor($this->images->{'files_dodajnowy.png'});
        $list_widget->set_pagination($pagination);
        $list_widget->set_breadcrumb($this->get_parents_path((int) @$_GET['parent']));

        $this->template->content = $this->get_message_view() . $list_widget->render();
    }

    protected function get_parents_path($parent = 0) {
        return array();
    }

    protected function get_renderers() {
        return array();
    }

    public function action_edit() {
        $this->redirect_if_language_changed();
        if (isset($_POST['save'])) {
            $this->action_save();
        } else {
            $this->edit_form = $this->factory->get_form($this->request->param('id'), $this->get_site());
            $this->show_view();
        }
    }
    
    protected function redirect_if_language_changed() {
        $item = ORM::factory($this->content_name)->where($this->translation_table . '.id', '=', $this->request->param('id'))->find();
        if ($item->id and $item->language_id != Kohana_Session::instance()->get('application_language')) {
            $content_id = ORM::factory($this->content_name)->where($this->translation_table . '.content_id', '=', $item->content_id)
                    ->where($this->translation_table . '.language_id', '=', Kohana_Session::instance()->get('application_language'))
                    ->find()->id;
            $this->redirect($this->new_item_uri . '/' . $content_id);
            die;
        }
    }

    public function action_save() {
        $_POST['id'] = $this->request->param('id');
        $_POST['id_parent'] = @$_GET['parent'];
        $this->edit_form = $this->factory->get_form($this->request->param('id'), array_merge($_POST, $_FILES));
        unset($_POST['id']);
        if ($this->edit_form->is_valid()) {
            $content_arr = array_merge(
                            $this->edit_form->get_validated_array(),
                            array('kind_id' => $this->model_content->get_content_kind_id())
            );
            if(!isset($content_arr['id_parent']) or $content_arr['id_parent'] == NULL) {
                $content_arr['id_parent'] = $this->model_content->id_parent;
            }
            $this->model_content->values($content_arr);
            $this->model_content->save();
//            $this->action_back(1);
            $this->redirect($this->get_controller_name() . '/edit/' . $this->model_content->id .'?success=1');
        } else {
            $this->set_operation_status(self::OPERATION_ERROR);
            $this->show_view();
        }
    }

    public function action_delete() {
        $this->model_content->delete();
        $this->action_back(1);
    }

    public function action_changesort() {
        $this->model_content->change_sort((string) $_POST['sort']);
        $this->action_back(1);
    }

    abstract protected function get_column_names();

    abstract protected function prepare_sites($sites);

    protected function get_id_and_controller_for_element($element) {
        $values = parent::get_id_and_controller_for_element($element);
        $pagination = $this->get_pagination($this->model_content);
        $values['old_sort'] = $element['sort'];
        $values['max_sort'] = $pagination->total_items;
        $values['query_string'] = array();
        if ($this->page_number > 1) {
            $values['query_string']['page'] = $this->page_number;
        }
        if (@$_GET['parent'] > 0) {
            $values['query_string']['parent'] = @$_GET['parent'];
        }
        return $values;
    }

    protected function show_view() {
        $form = new Widget_Decorator_Title($this->edit_form);
        $form->set_view(self::VIEW);
        $form->set_title($this->get_edit_view_title());
        $this->template->content = $this->get_message_view() . $this->render_tabs_view() . $form->render();
    }

    protected function get_tabs_view() {
        return array();
    }

    protected function render_tabs_view() {
        if($this->model_content->is_new()) {
            return NULL;
        }
        $view = View::factory('admin/common/tabs');
        $view->tabs = $this->get_tabs_view();
        return $view->render();
    }

    abstract protected function get_edit_view_title();

    private function get_site() {
        return $this->model_content->as_array();
    }
    
}

?>
