<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Communicate_Short extends Controller_Admin_Communicate {

    protected $controller_address = 'admin/communicate_short';
    protected $form_class_name = 'Form_Communicate_Short';
    protected $form = NULL;
    protected $errors;
    protected $list_title = 'Tłumaczenia';

    protected function get_all_translations() {
        $translations = Translation::get_full_list(Translation::TYPE_SHORT);
        return $translations;
    }

    protected function add_translation($values) {
        return Translation::add_one($values, Translation::TYPE_SHORT);
    }

    protected function prepare_rows($rows) {
	foreach ($rows as &$row) {
            $id_and_controller = $this->get_id_and_controller_for_element($row);
	    $row['edit'] = $id_and_controller;
	}
	return $rows;
    }

    protected function get_controller_name() {
        return $this->controller_address;
    }

    protected function get_form($id, $values) {
        return new Form_Translation_Short($this->controller_address.'/edit/'.$id, $values);
    }

    protected function get_renderers() {
        return array(
            array(
                'renderer' => 'Translation_Short',
                'column' => 'values',
                'row' => '*'
            ),
	    array(
		'renderer' => 'Edit',
		'column' => 'edit',
		'row' => '*'
	    )
	);
    }

}

?>
