<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Communicate extends Controller_Admin_Frame {

    protected $controller_address = NULL;
    protected $form_class_name = NULL;
    protected $new_item_uri = NULL;
    protected $view = 'common/form/titled';
    protected $title = NULL;

    public function __construct($request) {
        parent::__construct($request);
        $this->message = $this->get_message_view();
    }

    public function action_index() {
        $this->template->content = NULL;

        $translations = $this->get_all_translations();
        $translations = $this->prepare_rows($translations);
        $columns = $this->get_column_names();
        $list_widget = Widget_List_Factory::get_list_widget(View::V_LIST, $columns, $translations, $this->request->controller, $this->get_renderers());
        $list_widget->set_title($this->list_title);
        $list_widget->set_uri($this->new_item_uri);
        $list_widget->set_anchor($this->images->{'files_dodajnowy.png'});

        $this->template->content = $this->get_message_view() . $this->new_item_form() . $list_widget->render();
    }

    private function new_item_form() {
        $view = '';
        if (simpleauth::instance()->has_role('atech')) {
            $form = new Form_Translation($this->controller_address, $_POST);
            if (isset($_POST['add'])) {
                if($form->is_valid()) {
                    $new_translation = $this->add_translation($form->get_validated_array());
                    $this->redirect($this->controller_address . '/edit/' . $new_translation->id);
                    die;
                }
            }
            $view_setup = new Widget_Decorator_Title($form);
            $view_setup->set_view($this->view);
            $view_setup->set_title('Dodaj Tłumaczenie');
            $view = $view_setup->render();
        }
        return $view;
    }

    protected function add_translation($values) {
        return NULL;
    }

    protected function prepare_rows($rows) {
        return $rows;
    }

    protected function get_all_translations() {
        return NULL;
    }

    protected function get_translation($id = NULL, $values = NULL) {
        $base = Translation::get_one($id);
        if (is_array($values)) {
            foreach ($values as $label => $value) {
                foreach ($base as $lang => $translation) {
                    if ($label == 'value_'.$translation['language_id']) {
                        $base[$lang]['value'] = $value;
                    }
                }
            }
        }
        return $base;
    }

    protected function get_renderers() {
        return array();
    }
    
    protected function get_column_names() {
	return array(
	    'label' => Widget_List_Columns::get_column('', 'Etykieta'),
            'values' => Widget_List_Columns::get_column(400, 'Wartości'),
	    'edit' => Widget_List_Columns::get_column(Widget_List_Columns::W_ACTION, Widget_List_Columns::L_EDIT, 'center'));
    }

    public function action_edit() {
        if (isset($_POST['save'])) {
            $this->action_save();
        } elseif (isset($_POST['back'])) {
            $this->action_back();
            die;
        } else {
            $this->edit_form = $this->get_form($this->request->param('id'), $this->get_translation($this->request->param('id')));
            $this->show_view();
        }
    }

    public function action_save() {
        $_POST['id'] = $this->request->param('id');
        $this->edit_form = $this->get_form($this->request->param('id'), $this->get_translation($this->request->param('id'), $_POST));
        unset($_POST['id']);
        foreach ($this->edit_form->get_validated_array() as $label => $value) {
            $id_lang = UTF8::str_ireplace('value_', '', $label);
            ORM::factory('Translation_Detail')
                    ->where('translation_id', '=', $this->request->param('id'))
                    ->where('language_id', '=', $id_lang)
                    ->find()
                    ->values(array('value' => $value))
                    ->save();
        }
        $this->action_back(1);
    }

    public function action_back($success = NULL) {
        $query_string = '';
        if (!is_null($success)) {
            $query_string .= (($query_string != '') ? '&' : '?') . 'success=' . $success;
        }
        $this->redirect('admin/' . $this->request->controller . ($query_string != '' ? '/index/' . $query_string : ''));
    }

    protected function get_form($id, $values) {
        return NULL;
    }

    private function show_view() {
        $form = new Widget_Decorator_Title($this->edit_form);
        $form->set_view($this->view);
        $form->set_title($this->get_edit_view_title());
        $this->template->content = $this->get_message_view() . $form->render();
    }

    protected function get_edit_view_title() {
	if (!$this->request->param('id')) {
	    return 'Dodawanie Tłumaczenia';
	} else {
	    return 'Edycja Tłumaczenia';
	}
    }

}

?>
