<?php

defined('SYSPATH') or die('No direct script access.');

/**
 * Klasa obsługuje ścieżkę "jesteś tutaj"
 *
 * @author Andrzej Skupień
 * @version 1.0
 */
class Breadcrumb {
    //poniższe stałe ORDER_ okresłają kolejnośc wyświetlania linków w ścieżce
    const ORDER_CATEGORY = 0;
    const ORDER_SITE = 10;
    const ORDER_TEXT = 15;

    //klasa css dla elementów w ścieżce
    const CLASS_NAME = 'path';
    private $crumbs = array();

    public function __toString() {
	try {
	    return $this->render();
	} catch (Exception $e) {
	    // Display the exception message
	    Kohana::exception_handler($e);
	    return '';
	}
    }

    public function render() {
	$view = Kohana_View::factory('breadcrumb');
	//soritwanie według warotści stałych ORDER_
	ksort($this->crumbs);
	$view->crumbs = $this->crumbs;

	try {
	    return $view->render();
	} catch (Exception $e) {
	    // Display the exception message
	    Kohana::exception_handler($e);
	    return '';
	}
    }

    /**
     * Ustawienie składowej dla kategorii
     * @param Link $link
     */
    public function set_category(Link $link) {
	$this->add_link_to_crumbs($link, self::ORDER_CATEGORY);
    }

    /**
     * Ustawienie składowej dla strony tekstowej (battalion/gh)
     * @param Link $link
     */
    public function set_site(Link $link) {
	$this->add_link_to_crumbs($link, self::ORDER_SITE);
    }
    //dodawanie nieaktywnych linków
   public function set_site_text(Link $link) {
	$this->add_link_to_crumbs($link, self::ORDER_TEXT);
    }

    public function add_link_to_crumbs(Link $link, $order) {
	//link musi byc klonowany, bo jest zmieniana jego klasa
	$link = clone $link;
        $link->set_class(self::CLASS_NAME);
	$this->crumbs[$order] = $link;
    }
   
}

?>
