<?php

defined('SYSPATH') or die('No direct access allowed.');

class Arr extends Kohana_Arr {

    public static function range($step = 1, $max = 100, $start=NULL) {
        if ($step < 1) {
            return array();
        }
        if (is_null($start)) {
            $start = $step;
        }

        $range = range($start, $max, $step);
        return array_combine($range, $range);
    }

    public static function smart_range($min = 1, $max = 100, $start = NULL, $range = 20, $mid = 1) {
        if (is_null($start)) {
            $start = $step;
        }

        $values = array();
        for ($i=1; $i<20; $i++) {
            $values[] = $mid+$i;
            $values[] = $mid-$i;
        }
        $tmp_min = min($values);
        $tmp_max = max($values);
        for ($i=1; $i<=strlen($max); $i++) {
            $base = pow(10, $i);
            for($j=1; $j<=10; $j++) {
                $values[] = ($tmp_max + ($j*$base));
                $values[] = ($tmp_min - ($j*$base));
            }
        }
        $values[] = $mid;
        $values[] = $min;
        $values[] = $max;
        foreach ($values as $key => $value) {
            if ($value > $max or $value < $min) {
                unset ($values[$key]);
            }
        }
        sort($values);
        return array_combine($values, $values);
    }

    public static function array_to_matrix(array $array, $columns, $default_value = '&nbsp;') {
        $columns_number = self::get_columns_number($columns);
        $columns_keys = self::get_columns_keys($columns);
        $missed_fields_number = (count($array) % $columns_number);
        for($i=0; $i<$missed_fields_number; $i++) {
            $array[] = $default_value;
        }
        $array = array_reverse($array);
        $matrix = array();
        $row_number = 0;
        while(count($array)) {
            foreach($columns_keys as $key) {
                $matrix[$row_number][$key] = array_pop($array);
            }
            $row_number++;
        }
        return $matrix;
    }
    private static function get_columns_number($columns) {
        if(is_array($columns)) {
            return count($columns);
        }
        elseif(is_integer($columns)) {
            return $columns;
        }
        else {
            throw new Exception('Nieprawidłowy typ zmiennej $columns');
        }
    }
    private static function get_columns_keys($columns) {
        if(is_array($columns)) {
            return $columns;
        }
        elseif(is_integer($columns)) {
            return Arr::range(1, $columns);
        }
        else {
            throw new Exception('Nieprawidłowy typ zmiennej $columns');
        }
    }

}