<?php

defined('SYSPATH') or die('No direct script access.');

//-- Environment setup --------------------------------------------------------

ini_set('xdebug.var_display_max_depth', 7);
define('IN_PRODUCTION', $_SERVER['SERVER_ADDR'] != '127.0.0.1');
Kohana::$environment = (IN_PRODUCTION === TRUE) ? Kohana::PRODUCTION : Kohana::DEVELOPMENT;
Kohana::$environment = Kohana::PRODUCTION;
if (Kohana::$environment === Kohana::PRODUCTION) {
    error_reporting(0);
}
/**
 * Set the default time zone.
 *
 * @see  http://kohanaframework.org/guide/using.configuration
 * @see  http://php.net/timezones
 */
date_default_timezone_set('Europe/Warsaw');

/**
 * Set the default locale.
 *
 * @see  http://kohanaframework.org/guide/using.configuration
 * @see  http://php.net/setlocale
 */
setlocale(LC_ALL, 'pl_PL.utf-8');

/**
 * Enable the Kohana auto-loader.
 *
 * @see  http://kohanaframework.org/guide/using.autoloading
 * @see  http://php.net/spl_autoload_register
 */
spl_autoload_register(array('Kohana', 'auto_load'));

/**
 * Enable the Kohana auto-loader for unserialization.
 *
 * @see  http://php.net/spl_autoload_call
 * @see  http://php.net/manual/var.configuration.php#unserialize-callback-func
 */
ini_set('unserialize_callback_func', 'spl_autoload_call');

//-- Configuration and initialization -----------------------------------------

/**
 * Initialize Kohana, setting the default options.
 *
 * The following options are available:
 *
 * - string   base_url    path, and optionally domain, of your application   NULL
 * - string   index_file  name of your index file, usually "index.php"       index.php
 * - string   charset     internal character set used for input and output   utf-8
 * - string   cache_dir   set the internal cache directory                   APPPATH/cache
 * - boolean  errors      enable or disable error handling                   TRUE
 * - boolean  profile     enable or disable internal profiling               TRUE
 * - boolean  caching     enable or disable internal caching                 FALSE
 */
Kohana::init(array(
	    'base_url' => '/',
	    'index_file' => FALSE,
	    'profile' => FALSE, //Kohana::$environment !== Kohana::PRODUCTION,
	    'errors' => Kohana::$environment !== Kohana::PRODUCTION,
//	    'caching' => Kohana::$environment === Kohana::PRODUCTION,
	));

/**
 * Attach the file write to logging. Multiple writers are supported.
 */
Kohana::$log->attach(new Kohana_Log_File(APPPATH . 'logs'));

/**
 * Attach a file reader to config. Multiple readers are supported.
 */
Kohana::$config->attach(new Kohana_Config_File);

/**
 * Enable modules. Modules are referenced by a relative or absolute path.
 */
Kohana::modules(array(
	    //'auth' => MODPATH . 'auth', // Basic authentication
	    // 'cache'      => MODPATH.'cache',      // Caching with multiple backends
	    'database' => MODPATH . 'database', // Database access
	    'image'      => MODPATH.'image',      // Image manipulation
	    'orm' => MODPATH . 'orm', // Object Relationship Mapping
	    'pagination' => MODPATH . 'pagination', // Paging of results
	    'simpleauth' => MODPATH . 'simpleauth',
	    'email' => MODPATH . 'email',
	    'option' => MODPATH . 'option',
	    //'rights' => MODPATH . 'rights',
	    'images' => MODPATH . 'images',
            'translation' => MODPATH . 'translation',
	    'firephp' => MODPATH . 'firephp',
	    'captcha' => MODPATH . 'captcha',
	    'sitemap' => MODPATH . 'sitemap'
	));

/**
 * Set the routes. Each route must have a minimum of a name, a URI and a set of
 * defaults for the URI.
 */
Route::set('media', 'media/<app>/<type>/<file>');

Route::set('admin', 'admin(/<controller>(/<action>(/<id>)))')
	->defaults(array(
	    'directory' => 'admin',
	    'controller' => 'welcome',
	    'action' => 'index',
	));


Route::set('site_file', 'admin/<controller>/<kind_id>/<element_id>/<action>(/<id>)',
        array(
            'kind_id' => '[0-9]+',
            'element_id' => '[0-9]+',
        ))
        ->defaults(array(
            'directory' => 'admin',
            'controller' => 'site_file',
            'action' => 'index'
        ));

Route::set(Route::BASIC, '(<' . Route::CONTROLLER . '>(/<' . Route::ACTION . '>(/<' . Route::ID . '>(,<' . Route::USER_FRIENDLY . '>))))')
	->defaults(array(
	    Route::CONTROLLER => 'main',
	    Route::ACTION => 'index',
	));
FB::setEnabled((Kohana::$environment !== Kohana::PRODUCTION));

Profiler::$rollover = 5;


if (!defined('SUPPRESS_REQUEST')) {
    /**
     * Execute the main request using PATH_INFO. If no URI source is specified,
     * the URI will be automatically detected.
     */
    $request = Request::instance($_SERVER['PATH_INFO']);

    try {
	// Attempt to execute the response
	$request->execute();
    } catch (Exception $e) {
	if (Kohana::$environment == Kohana::DEVELOPMENT) {
	    // Just re-throw the exception
	    throw $e;
	}
	// Log the error
	Kohana::$log->add(Kohana::ERROR, Kohana::exception_text($e));

	// Set the error code
	$error_code = 404;
	if ($e instanceof ReflectionException OR !$e->getCode()) {
	    $error_code = 404;
	} elseif ($e instanceof ErrorException) {
	    $error_code = 500;
	} elseif ($e->getCode()) {
	    $error_code = $e->getCode();
	}


	// Create a 404 response
	$request->status = $error_code;
        $selected_language = Kohana_Session::instance()->get('application_language');
        if (!$selected_language) {
            $selected_language = 1;
        }
	$request->response = View::factory($request->directory . '/404')
                ->set('translations', new Translation($selected_language))
                ->set('title', '404 - ' . Request::$messages[$error_code])
                ->set('message', $e->getMessage());
    }
    /**
     * Display the request response.
     */
    $request->send_headers();
    echo $request->response;
}
